package com.icetech.park.domain.dto.sms;

import com.icetech.park.domain.entity.sms.SmsAlarmConfig;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString(callSuper = true)
@Accessors(chain = true)
public class SmsAlarmConfigDto extends SmsAlarmConfig {
    /** 车场名称 */
    protected String parkName;
    /**
     * 车场数据采集方式(1-端云;2-端网云;)
     * @see com.icetech.cloudcenter.domain.enumeration.DataCollectionEnum
     */
    protected Integer parkDataCollection;
    protected String deviceRecvPhones;
    protected String pncCenterRecvPhones;
    protected String pncChargeRecvPhones;
    /** 是否存在订单(0/1) */
    protected Integer existsOrder;
    /** 是否存在发送记录(0/1) */
    protected Integer existsRecord;
}
