package com.icetech.park.domain.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @author wanggang
 * @create 2023-11-27 15:17
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class QueryWorkOrderDTO implements Serializable {

    /**
     * 第几页
     */
    private Integer pageNo = 1;

    /**
     * 每页展示多少条
     */
    private Integer pageSize = 10;

    /**
     * 工单状态：:0;待处理;1处理中;2已完成;3已取消
     */
    private Integer status;

    /**
     * 优先级类型
     */
    private List<PriorityType> priorityTypes;

    /**
     * 车场id
     */
    private Long parkId;

    /**
     * 工单编号
     */
    private String code;

    /**
     * 用户视图:1我创建的;2我负责的
     */
    private Integer view;

    /**
     * 报单查询开始时间:2019-05-21 16:37:16
     */
    private String startTime;

    /**
     * 报单查询开始时间:2019-05-21 16:37:16
     */
    private String endTime;
    
    @Data
    public static class PriorityType {
        /**
         * 优先级:1非常紧急;2紧急;3一般
         */
        private Integer priority;

        /**
         * 单类型：工单类型:(非常紧急:11系统故障;12:设备故障报修;13:网络通讯故障);(紧急:21软件问题;22:现场安装;23:设备升级和调试);(一般:31计费错误;32:用户培训和指导;33:现场保养;34:远程)
         */
        private List<Integer> types;
    }

}
