package com.icetech.park.domain;

public enum CityIdEnum {
    BEIJING("北京", "010"),
    TIANJIN("天津", "022"),
    SHIJIAZHUANG("石家庄", "0311"),
    TANGSHAN("唐山", "0315"),
    QINHUANGDAO("秦皇岛", "0335"),
    HANDAN("邯郸", "0310"),
    XINGTAI("邢台", "0319"),
    BAODING("保定", "0312"),
    ZHANGJIAKOU("张家口", "0313"),
    CHENGDE("承德", "0314"),
    CANGZHOU("沧州", "0317"),
    LANGFANG("廊坊", "0316"),
    HENGSHUI("衡水", "0318"),
    TAIYUAN("太原", "0351"),
    DATONG("大同", "0352"),
    YANGQUAN("阳泉", "0353"),
    CHANGZHI("长治", "0355"),
    JINCHENG("晋城", "0356"),
    SHUOZHOU("朔州", "0349"),
    JINZHONG("晋中", "0354"),
    YUNCHENG("运城", "0359"),
    XINZHOU("忻州", "0350"),
    LINFEN("临汾", "0357"),
    LVLIANG("吕梁", "0358"),
    HOHHOT("呼和浩特", "0471"),
    BAOTOU("包头", "0472"),
    WUHAI("乌海", "0473"),
    CHIFENG("赤峰", "0476"),
    TONGLIAO("通辽", "0475"),
    ORDOS("鄂尔多斯", "0477"),
    HULUNBER("呼伦贝尔", "0470"),
    BAYANNUR("巴彦淖尔", "0478"),
    ULANQAB("乌兰察布", "0474"),
    HINGGAN("兴安盟", "0482"),
    XILINGOL("锡林郭勒盟", "0479"),
    ALXA("阿拉善盟", "0483"),
    SHENYANG("沈阳", "024"),
    DALIAN("大连", "0411"),
    ANSHAN("鞍山", "0412"),
    FUSHUN("抚顺", "024"),
    BENXI("本溪", "0414"),
    DANDONG("丹东", "0415"),
    JINZHOU("锦州", "0416"),
    YINGKOU("营口", "0417"),
    FUXIN("阜新", "0418"),
    LIAOYANG("辽阳", "0419"),
    PANJIN("盘锦", "0427"),
    TIELING("铁岭", "024"),
    CHAOYANG("朝阳", "0421"),
    HULUDAO("葫芦岛", "0429"),
    JINPUXINQU("金普新区", "0411"),
    CHANGCHUN("长春", "0431"),
    JILIN("吉林", "0432"),
    SIPING("四平", "0434"),
    LIAOYUAN("辽源", "0437"),
    TONGHUA("通化", "0435"),
    BAISHAN("白山", "0439"),
    SONGYUAN("松原", "0438"),
    BAICHENG("白城", "0436"),
    YANBIAN("延边", "0433"),
    HARBIN("哈尔滨", "0451"),
    QIQIHAR("齐齐哈尔", "0452"),
    JIXI("鸡西", "0467"),
    HEGANG("鹤岗", "0468"),
    SHUANGYASHAN("双鸭山", "0469"),
    DAQING("大庆", "0459"),
    YICHUN("伊春", "0458"),
    JIANGXI_YICHUN("宜春", "0795"),
    JIAMUSI("佳木斯", "0454"),
    QITAIHE("七台河", "0464"),
    MUDANJIANG("牡丹江", "0453"),
    HEIHE("黑河", "0456"),
    SUIHUA("绥化", "0455"),
    DAXINGANLING("大兴安岭", "0457"),
    SHANGHAI("上海", "021"),
    NANJING("南京", "025"),
    WUXI("无锡", "0510"),
    XUZHOU("徐州", "0516"),
    CHANGZHOU("常州", "0519"),
    SUZHOU("苏州", "0512"),
    ANHUI_SUZHOU("宿州", "0557"),
    NANTONG("南通", "0513"),
    LIANYUNGANG("连云港", "0518"),
    HUAIAN("淮安", "0517"),
    YANCHENG("盐城", "0515"),
    YANGZHOU("扬州", "0514"),
    ZHENJIANG("镇江", "0511"),
    TAIZHOU("泰州", "0523"),
    ZHEJIANG_TAIZHOU("台州", "0576"),
    SUQIAN("宿迁", "0527"),
    HANGZHOU("杭州", "0571"),
    NINGBO("宁波", "0574"),
    WENZHOU("温州", "0577"),
    JIAXING("嘉兴", "0573"),
    HUZHOU("湖州", "0572"),
    SHAOXING("绍兴", "0575"),
    JINHUA("金华", "0579"),
    QUZHOU("衢州", "0570"),
    ZHOUSHAN("舟山", "0580"),
    LISHUI("丽水", "0578"),
    HEFEI("合肥", "0551"),
    WUHU("芜湖", "0553"),
    BENGBU("蚌埠", "0552"),
    HUAINAN("淮南", "0554"),
    MAANSHAN("马鞍山", "0555"),
    HUAIBEI("淮北", "0561"),
    TONGLING("铜陵", "0562"),
    ANQING("安庆", "0556"),
    HUANGSHAN("黄山", "0559"),
    CHUZHOU("滁州", "0550"),
    FUYANG("阜阳", "0558"),
    LUAN("六安", "0564"),
    BOZHOU("亳州", "0558"),
    CHIZHOU("池州", "0566"),
    XUANCHENG("宣城", "0563"),
    FUZHOU("福州", "0591"),
    JIANGXI_FUZHOU("抚州", "0794"),
    XIAMEN("厦门", "0592"),
    PUTIAN("莆田", "0594"),
    SANMING("三明", "0598"),
    QUANZHOU("泉州", "0595"),
    ZHANGZHOU("漳州", "0596"),
    NANPING("南平", "0599"),
    LONGYAN("龙岩", "0597"),
    NINGDE("宁德", "0593"),
    NANCHANG("南昌", "0791"),
    JINGDEZHEN("景德镇", "0798"),
    PINGXIANG("萍乡", "0799"),
    JIUJIANG("九江", "0792"),
    XINYU("新余", "0790"),
    YINGTAN("鹰潭", "0701"),
    GANZHOU("赣州", "0797"),
    JIAN("吉安", "0796"),
    SHANGRAO("上饶", "0793"),
    JINAN("济南", "0531"),
    QINGDAO("青岛", "0532"),
    ZIBO("淄博", "0533"),
    ZAOZHUANG("枣庄", "0632"),
    DONGYING("东营", "0546"),
    YANTAI("烟台", "0635"),
    WEIFANG("潍坊", "0536"),
    JINING("济宁", "0537"),
    TAIAN("泰安", "0538"),
    WEIHAI("威海", "0631"),
    RIZHAO("日照", "0633"),
    LAIWU("莱芜", "0634"),
    LINYI("临沂", "0539"),
    DEZHOU("德州", "0534"),
    LIAOCHENG("聊城", "0635"),
    BINZHOU("滨州", "0543"),
    HEZE("菏泽", "0530"),
    ZHENGZHOU("郑州", "0371"),
    KAIFENG("开封", "0378"),
    LUOYANG("洛阳", "0379"),
    PINGDINGSHAN("平顶山", "0375"),
    ANYANG("安阳", "0372"),
    HEBI("鹤壁", "0392"),
    XINXIANG("新乡", "0373"),
    JIAOZUO("焦作", "0391"),
    PUYANG("濮阳", "0393"),
    XUCHANG("许昌", "0374"),
    LUOHE("漯河", "0395"),
    SANMENXIA("三门峡", "0398"),
    NANYANG("南阳", "0377"),
    SHANGQIU("商丘", "0370"),
    XINYANG("信阳", "0376"),
    ZHOUKOU("周口", "0394"),
    ZHUMADIAN("驻马店", "0396"),
    WUHAN("武汉", "027"),
    HUANGSHI("黄石", "0714"),
    SHIYAN("十堰", "0719"),
    YICHANG("宜昌", "0717"),
    XIANGYANG("襄阳", "0710"),
    EZHOU("鄂州", "0711"),
    JINGMEN("荆门", "0724"),
    XIAOGAN("孝感", "0712"),
    JINGZHOU("荆州", "0716"),
    HUANGGANG("黄冈", "0713"),
    XIANNING("咸宁", "0715"),
    SUIZHOU("随州", "0722"),
    ENSHI("恩施", "0718"),
    CHANGSHA("长沙", "0731"),
    ZHUZHOU("株洲", "0731"),
    XIANGTAN("湘潭", "0731"),
    HENGYANG("衡阳", "0734"),
    SHAOYANG("邵阳", "0739"),
    YUEYANG("岳阳", "0730"),
    CHANGDE("常德", "0736"),
    ZHANGJIAJIE("张家界", "0744"),
    YIYANG("益阳", "0737"),
    CHENZHOU("郴州", "0735"),
    YONGZHOU("永州", "0746"),
    HUAIHUA("怀化", "0745"),
    LOUDI("娄底", "0738"),
    XIANGXI("湘西", "0743"),
    GUANGZHOU("广州", "020"),
    SHAOGUAN("韶关", "0751"),
    SHENZHEN("深圳", "0755"),
    ZHUHAI("珠海", "0756"),
    SHANTOU("汕头", "0754"),
    FOSHAN("佛山", "0757"),
    JIANGMEN("江门", "0750"),
    ZHANJIANG("湛江", "0759"),
    MAOMING("茂名", "0668"),
    ZHAOQING("肇庆", "0758"),
    HUIZHOU("惠州", "0752"),
    MEIZHOU("梅州", "0753"),
    SHANWEI("汕尾", "0660"),
    HEYUAN("河源", "0762"),
    YANGJIANG("阳江", "0662"),
    QINGYUAN("清远", "0763"),
    DONGGUAN("东莞", "0769"),
    ZHONGSHAN("中山", "0760"),
    CHAOZHOU("潮州", "0768"),
    JIEYANG("揭阳", "0633"),
    YUNFU("云浮", "0766"),
    NANNING("南宁", "0771"),
    LIUZHOU("柳州", "0772"),
    GUILIN("桂林", "0773"),
    WUZHOU("梧州", "0774"),
    BEIHAI("北海", "0779"),
    FANGCHENGGANG("防城港", "0770"),
    QINZHOU("钦州", "0777"),
    GUIGANG("贵港", "0775"),
    YULIN("玉林", "0775"),
    SHANXI_YULIN("榆林", "0912"),
    BAISE("百色", "0776"),
    HEZHOU("贺州", "0774"),
    HECHI("河池", "0778"),
    LAIBIN("来宾", "0772"),
    CHONGZUO("崇左", "0771"),
    HAIKOU("海口", "0898"),
    SANYA("三亚", "0898"),
    SANSHA("三沙", "0898"),
    CHONGQING("重庆", "023"),
    LIANGJIANGXINQU("两江新区", "023"),
    CHENGDU("成都", "028"),
    ZIGONG("自贡", "0813"),
    PANZHIHUA("攀枝花", "0812"),
    LUZHOU("泸州", "0830"),
    DEYANG("德阳", "0838"),
    MIANYANG("绵阳", "0816"),
    GUANGYUAN("广元", "0839"),
    SUINING("遂宁", "0825"),
    NEIJIANG("内江", "0832"),
    LESHAN("乐山", "0833"),
    NANCHONG("南充", "0817"),
    MEISHAN("眉山", "028"),
    YIBIN("宜宾", "0831"),
    GUANGAN("广安", "0826"),
    DAZHOU("达州", "0818"),
    YAAN("雅安", "0835"),
    BAZHONG("巴中", "0827"),
    ZIYANG("资阳", "028"),
    ABA("阿坝", "0837"),
    GARZE("甘孜", "0836"),
    LIANGSHAN("凉山", "0834"),
    GUIYANG("贵阳", "0851"),
    LIUPANSHUI("六盘水", "0858"),
    ZUNYI("遵义", "0852"),
    ANSHUN("安顺", "0853"),
    BIJIE("毕节", "0857"),
    TONGREN("铜仁", "0856"),
    QIANXINAN("黔西南", "0859"),
    QIANDONGNAN("黔东南", "0855"),
    QIANNAN("黔南", "0854"),
    KUNMING("昆明", "0871"),
    QUJING("曲靖", "0874"),
    YUXI("玉溪", "0877"),
    BAOSHAN("保山", "0875"),
    ZHAOTONG("昭通", "0870"),
    LIJIANG("丽江", "0888"),
    PUER("普洱", "0879"),
    LINCANG("临沧", "0883"),
    CHUXIONG("楚雄", "0878"),
    HONGHE("红河", "0873"),
    WENSHAN("文山", "0876"),
    XISHUANGBANNA("西双版纳", "0691"),
    DALI("大理", "0872"),
    DEHONG("德宏", "0692"),
    NUJIANG("怒江", "0886"),
    DEQEN("迪庆", "0887"),
    LHASA("拉萨", "0891"),
    RIKAZE("日喀则", "0892"),
    QAMDO("昌都", "0895"),
    SHANNAN("山南", "0893"),
    NAGQU("那曲", "0896"),
    NGARI("阿里", "0897"),
    NYINGCHI("林芝", "0894"),
    XIAN("西安", "029"),
    TONGCHUAN("铜川", "0919"),
    BAOJI("宝鸡", "0917"),
    XIANYANG("咸阳", "029"),
    WEINAN("渭南", "0913"),
    YANAN("延安", "0911"),
    HANZHONG("汉中", "0916"),
    ANKANG("安康", "0915"),
    SHANGLUO("商洛", "0914"),
    XIXIAN("西咸", "029"),
    LANZHOU("兰州", "0931"),
    JIAYUGUAN("嘉峪关", "0937"),
    JINCHANG("金昌", "0935"),
    BAIYIN("白银", "0943"),
    TIANSHUI("天水", "0938"),
    WUWEI("武威", "0935"),
    ZHANGYE("张掖", "0936"),
    PINGLIANG("平凉", "0933"),
    JIUQUAN("酒泉", "0937"),
    QINGYANG("庆阳", "0934"),
    DINGXI("定西", "0932"),
    LONGNAN("陇南", "0939"),
    LINXIA("临夏", "0930"),
    GANNAN("甘南", "0941"),
    XINING("西宁", "0971"),
    HAIDONG("海东", "0972"),
    HAIBEI("海北", "0970"),
    HUANGNAN("黄南", "0973"),
    HAINAN("海南", "0974"),
    GOLOG("果洛", "0975"),
    YUSHU("玉树", "0976"),
    HAIXI("海西", "0977"),
    YINCHUAN("银川", "0951"),
    SHIZUISHAN("石嘴山", "0952"),
    WUZHONG("吴忠", "0953"),
    GUYUAN("固原", "0954"),
    ZHONGWEI("中卫", "0955"),
    URUMQI("乌鲁木齐", "0991"),
    KARAMAY("克拉玛依", "0990"),
    TURPAN("吐鲁番", "0995"),
    HAMI("哈密", "0902"),
    CHANGJI("昌吉", "0994"),
    BORTALA("博尔塔拉", "0909"),
    BAYINGOL("巴音郭楞", "0996"),
    AKSU("阿克苏", "0997"),
    KIZILSU("克孜勒苏", "0908"),
    KASHGAR("喀什", "0998"),
    HOTAN("和田", "0903"),
    ILI("伊犁", "0999"),
    QOQEK("塔城", "0901"),
    ALTAY("阿勒泰", "0906"),
    TAIPEI("台北", "02"),
    KAOHSIUNG("高雄", "07"),
    KEELUNG("基隆", "02"),
    TAICHUNG("台中", "04"),
    TAINAN("台南", "06"),
    HSINCHU("新竹", "03"),
    CHIAYI("嘉义", "05"),
    NEWTAIPEI("新北", "02"),
    YILAN("宜兰", "03"),
    TAOYUAN("桃园", "03"),
    MIAOLI("苗栗", "037"),
    CHANGHUA("彰化", "04"),
    NANTOU("南投", "049"),
    YUNLIN("云林", "05"),
    PINGTUNG("屏东", "08"),
    TAITUNG("台东", "089"),
    HUALIEN("花莲", "03"),
    PENGHU("澎湖", "06"),
    JINMEN("金门", "082"),
    LIENCHIANG("连江", "0836"),
    HONGKONGISLAND("香港岛", "00852"),
    KOWLOON("九龙", "00852"),
    NEWTERRITORIES("新界", "00852"),
    MACAUPENINSULA("澳门半岛", "00853"),
    TAIPA("氹仔岛", "00853"),
    COLOANE("路环岛", "00853");

    private String name;
    private String code;

    public static CityIdEnum getByTypeCode(String code) {
        for (CityIdEnum cityIdEnum : CityIdEnum.values()) {
            if (cityIdEnum.getCode().equals(code)) {
                return cityIdEnum;
            }
        }
        return null;
    }

    public static String getNameByTypeCode(String code) {
        for (CityIdEnum cityIdEnum : CityIdEnum.values()) {
            if (cityIdEnum.getCode().equals(code)) {
                return cityIdEnum.getName();
            }
        }
        return "";
    }

    /**
     * 传入城市名称获取编码
     **/
    public static String getCodeByCityName(String cityName) {
        for (CityIdEnum cityIdEnum : CityIdEnum.values()) {
            if (cityName.startsWith(cityIdEnum.getName())) {
                return cityIdEnum.getCode();
            }
        }
        return "";
    }

    // 构造方法
    CityIdEnum(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}
