package com.icetech.park.domain.vo.full;

import com.alibaba.fastjson2.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * Payload内容
 *
 * @author wgq
 */
@Data
public class UpSnapshotVO {

    /**
     * 状态码（200成功；500失败）
     */
    @JsonProperty("state_code")
    @JSONField(name = "state_code")
    private int stateCode;

    /**
     * 图片格式（目前固定支持jpg）
     */
    private String imageformat;

    /**
     * 图片路径，Base64编码后的云存路径
     */
    private String imgPath;

    /**
     * Web 设置传图方式为Mqtt，并且使能背景图上传，此字段表示的背景图的Base64编码
     */
    @JsonProperty("image_content")
    @JSONField(name = "image_content")
    private String imageContent;
}
