package com.icetech.park.domain.vo.full;

import com.alibaba.fastjson2.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.icetech.park.domain.dto.full.CarLocationDTO;
import com.icetech.park.domain.dto.full.LocationDTO;
import com.icetech.park.domain.dto.full.TimestampDTO;
import lombok.Data;

import java.util.List;

/**
 * @author wgq
 */
@Data
public class PlateResultVO {

    /**
     * 亮度评价
     */
    private int bright;

    /**
     * 车牌列表，每组对应一个车牌
     */
    private List<PlateVO> plates;

    /**
     * 车牌 (GBK)，Base64编码
     */
    private String license;

    /**
     * 新型小型车牌扩展字段（0未知；1非运营；2运营；3政府车牌，R4、RM暂不支持）
     */
    @JsonProperty("license_ext_type")
    @JSONField(name = "license_ext_type")
    private int licenseExtType;

    /**
     * 车的亮度
     */
    private int carBright;

    /**
     * 车的颜色（0白；1银；2黄；3粉；4红；5绿；6蓝；7棕；8黑；9灰；255未知）
     */
    private int carColor;

    /**
     * 车辆品牌
     */
    @JsonProperty("car_brand")
    @JSONField(name = "car_brand")
    private CarBrandVO carBrand;

    /**
     * 车辆位置
     */
    @JsonProperty("car_location")
    @JSONField(name = "car_location")
    private CarLocationDTO carLocation;

    /**
     * 车辆清洗检测参数值，默认0
     */
    @JsonProperty("clean_time")
    @JSONField(name = "clean_time")
    private int cleanTime;

    /**
     * 车牌颜色序号
     */
    private int colorType;

    /**
     * 车牌颜色
     */
    private int colorValue;

    /**
     * 车牌可信度（0~100）
     */
    private int confidence;

    /**
     * 运动方向（0未知；1左；2右；3上；4下）
     */
    private int direction;

    /**
     * 车辆特征码（不支持）
     */
    @JsonProperty("feature_code")
    @JSONField(name = "feature_code")
    private Boolean featureCode;

    /**
     * 特写图，Base64编码后的云存路径
     */
    private String imageFragmentPath;

    /**
     * 特写图的Base64编码
     */
    @JsonProperty("small_image_content")
    @JSONField(name = "small_image_content")
    private String smallImageContent;

    /**
     * 背景图，Base64编码后的云存路径
     */
    private String imagePath;

    /**
     * 背景图的Base64编码
     */
    @JsonProperty("full_image_content")
    @JSONField(name = "full_image_content")
    private String fullImageContent;

    /**
     * 是否是伪车牌（0真；1伪）
     */
    @JsonProperty("is_fake_plate")
    @JSONField(name = "is_fake_plate")
    private int isFakePlate;

    /**
     * 是否离线数据（0 在线；暂不支持离线数据推送）
     */
    @JsonProperty("isoffline")
    @JSONField(name = "isoffline")
    private int isOffline;

    /**
     * 车牌位置矩形
     */
    private LocationDTO location;

    /**
     * 车牌距离相机的位置，单位dm
     */
    @JsonProperty("plate_distance")
    @JSONField(name = "plate_distance")
    private int plateDistance;

    /**
     * 车牌的真实宽度，单位cm
     */
    @JsonProperty("plate_true_width")
    @JSONField(name = "plate_true_width")
    private int plateTrueWidth;

    /**
     * 记录编号
     */
    private int plateid;

    /**
     * 时间戳
     */
    private TimestampDTO timeStamp;

    /**
     * 识别用时
     */
    private int timeUsed;

    /**
     * 触发类型
     */
    private int triggerType;

    /**
     * 车牌类型
     */
    private int type;

    /**
     * IO输出事件（暂不支持）
     */
    private List<Object> gioouts;
}
