package com.icetech.park.domain.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.icetech.user.domain.vo.SaasCsUserVo;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * Description WorkOrderTransitionDetailVo
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2023/11/28 17:05
 */
@Data
public class WorkOrderTransitionDetailVo implements Serializable {

    /**
     * 工单id
     */
    private Long workOrderId;

    /**
     * 0;待处理;1处理中;2已完成;3已取消;4:已退单
     */
    private Integer preStatus;

    /**
     * 当前状态:0;待处理;1处理中;2已完成;3已取消;4:已退单
     */
    private Integer currentStatus;

    /**
     * 触发事件
     */
    private String eventAction;

    /**
     * 操作人,客服为工单编号
     */
    private String operator;

    /**
     * 工单客服
     */
    private SaasCsUserVo saasCsUserVo;

    /**
     * 流转时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    private Date createTime;
}
