package com.icetech.park.domain.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author wanggang
 * @create 2023-07-31 10:33
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class SassShamPlateVo implements Serializable {

    /**
     * id
     */
    private Long id;

    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 车场名称
     */
    private String parkName;

    /**
     * 入场时间
     */
    private String enterTime;

    /**
     * 虚假车牌
     */
    private String plateNum;

    /**
     * 停车时长
     */
    private String  parkTime;

    /**
     * 车辆类型(1临时车2月卡车3特殊车辆，默认1)
     */
    private Integer type;

    /**
     * 报警时间
     */
    private Date alarmTime;

    /**
     * 报警通道名称
     */
    private String channelName;

    /**
     * 关联车牌号
     */
    private String relPlateNum;

    /**
     * 虚假车辆照片URL
     */
    private String carImage;

    /**
     * 关联车辆照片URL
     */
    private String relCarImage;
    /**
     * 入口名称
     */
    private String enterNo;

    /**
     * 订单状态:1在场;2离场;3已取消;4异常离场
     */
    private Integer serviceStatus;

    /**
     * 是否有子订单，0：否，1：是，默认为0
     */
    private Integer hasSon;

}
