package com.icetech.park.domain.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * Description ParkRecoveryOpenVo
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2023/7/24 17:32
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ParkRecoveryOpenVo implements Serializable {

    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 逃费追缴月费
     */
    private BigDecimal monthCharge;

    /**
     * 服务费用
     */
    private BigDecimal serviceCharge;

    /**
     * 支付 url
     */
    private String payData;
}
