package com.icetech.park.domain.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * Description ParkRecoveryApplyRequest
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2023/7/20 15:21
 */
@Data
public class ParkRecoveryApplyParam implements Serializable {

    /**
     * 车场id
     */
    @NotNull(message = "车场id不能为空")
    @ApiModelProperty(value = "车场id", example = "1", required = true, position = 1)
    private Long parkId;

    /**
     * 申请类型：1-试用，2-开通
     */
    @NotNull(message = "申请类型不能为空")
    @ApiModelProperty(value = "申请类型", example = "1", required = true, position = 2)
    private Integer applyType;

    /**
     * 联系人
     */
    @NotBlank(message = "联系人不能为空")
    @ApiModelProperty(value = "联系人", example = "admin", required = true, position = 3)
    private String contacts;

    /**
     * 联系电话
     */
    @NotBlank(message = "联系电话不能为空")
    @ApiModelProperty(value = "联系电话", example = "13811111111", required = true, position = 4)
    private String contactsNumber;
    
}
