package com.icetech.park.domain.enums;

import lombok.Getter;

/**
 * Description OrderStatus
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2023/11/24 15:30
 */
@Getter
public enum OrderStatus {

    PENDING(0, "待处理"),
    PROCESSING(1, "处理中"),
    COMPLETED(2, "已完成"),
    CANCELLED(3, "已取消"),
    RETURNED(4, "退单");

    private final int value;
    private final String description;

    OrderStatus(int value, String description) {
        this.value = value;
        this.description = description;
    }
    
    // 通过 value 查找枚举值
    public static OrderStatus find(int value) {
        for (OrderStatus status : OrderStatus.values()) {
            if (status.value == value) {
                return status;
            }
        }
        return null;
    }

}
