package com.icetech.park.domain.entity.sms;

import java.time.LocalTime;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.icetech.common.utils.DateUtils;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString(callSuper = true)
@Accessors(chain = true)
public class SmsAlarmRuleBaseNear extends SmsAlarmRuleBase {
    /** 提前天数 */
    @TableField(value = "`before_expire_days`")
    protected int beforeExpireDays;
    /** 报警频率(0-单次;1-每天;2-隔天;) */
    @TableField(value = "`frequency`")
    protected int frequency;
    /** 发送时间点 */
    @JsonFormat(pattern = DateUtils.DEFAULT_TIME_HM_PATTERN)
    @TableField(value = "`send_time`")
    protected LocalTime sendTime;
}
