package com.icetech.park.domain.entity.sms;

import java.io.Serializable;
import java.time.LocalDateTime;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.icetech.common.utils.DateUtils;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@TableName("`ice_sms_alarm_product`")
public class SmsAlarmProduct implements Serializable {
    /** ID */
    @TableId(value = "`id`")
    protected Long id;
    /** 套餐包含的短信条数 */
    @TableField(value = "`sms_count`")
    protected Integer smsCount;
    /** 套餐价格(元) */
    @TableField(value = "`sms_price`")
    protected Double smsPrice;
    /** 启用标识(0：否，1：是) */
    @TableField(value = "`enable_flag`")
    protected Integer enableFlag;
    /** 创建时间 */
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TableField(value = "`create_time`")
    protected LocalDateTime createTime;
    /** 更新时间 */
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TableField(value = "`update_time`")
    protected LocalDateTime updateTime;
}
