package com.icetech.park.domain.entity.park;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

@Setter
@Getter
@ToString
@TableName("ice_park_visit")
public class ParkVisit implements Serializable {

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;
    /**
     *预约记录编码(修改时候用）
     */
    private String visitNum;
    /**
     *
     */
    private Integer parkId;
    /**
     *车牌号码（多个逗号分隔）
     */
    private String plateNums;
    /**
     *访客联系方式
     */
    private String visitPhone;
    /**
     *访客姓名
     */
    private String visitName;
    /**
     *业主姓名
     */
    private String masterName;
    /**
     *业主电话
     */
    private String masterPhone;
    /**
     *到访原因
     */
    private String reason;
    /**
     *业主房号
     */
    private String masterNum;
    /**
     *预约开始时间
     */
    private Date startTime;
    /**
     *预约结束时间
     */
    private Date endTime;
    /**
     * 用户id
     */
    private Integer mpUserId;
    /**
     *
     */
    private Date createTime;
    /**
     *
     */
    private Date updateTime;
    /**
     * 访客车辆审核 1人工审核2自动审核
     */
    private Integer isAuto;
    /**
     * 审核状态：1未审核,2审核通过,3审核拒绝
     */
    private Integer checkStatus;
    /**
     * 提交来源 1云平台;2公众号;4第三方接口;5APP;7海大小程序;8国控商家优免
     */
    @TableField("`from`")
    private Integer from;
    /**
     * 来访者状态   1未来访/2已来访/3已出场/4已过期
     */
    private Integer visitStatus;
    /**
     * 入场时间
     */
    private Integer enterTime;
    /**
     * 离场时间
     */
    private Integer exitTime;
    /**
     * 允许多次进出   0=一次进出 1=多次进出 2=自定义次数
     */
    private Integer inoutMore;
    /**
     * 预约车进出次数
     */
    private Integer inoutNum;
    /**
     * 添加人
     */
    private String adder;
    /**
     * 来访者订单号
     */
    private String orderNum;
    private String editer;
    /**
     * 拒绝原因
     */
    @TableField("`checkreason`")
    private String checkReason;

    /**
     * 删除标识:false未删除;true已删除
     */
    private Boolean deleteFlag;

    /**
     * 是否包含优惠:0：否，1：是
     */
    private Integer isDiscount;

    /**
     * 关联商户下发的优惠模板ID
     */
    private Integer merchantDisId;

    /**
     * 商户id
     */
    private Integer merchantId;

    /**
     * 优惠类型1全免2减免时间3减免金额4折扣
     */
    private Integer type;

    /**
     * 优惠内容
     */
    private String amount;

    /**
     * 优惠发放记录标识:0未发放;1已发放
     */
    private Integer sendFlag;
}
