package com.icetech.park.domain.entity.park;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.apache.http.util.TextUtils;

import java.io.Serializable;
import java.util.Date;

@Setter
@Getter
@ToString
public class ParkSignPlate implements Serializable {
    private Long id;

    private String plateNum;

    private Integer parkId;
    private String requestId;

    private String parkCode;

    private Integer noSense;

    private Integer moneyLimit;

    private Integer departurePay;

    private Date createTime;

    private Date updateTime;
    private String plateColor;

    /**
     * 车牌颜色 1：蓝色；2：黄色；3：白色；4：黑色；5：绿色
     */
    public static String getPlateColor(Integer plateColorType){
        if (plateColorType == null){
            return "蓝色";
        }
        String plateColor = "蓝色";
        switch (plateColorType){
            case 1:
                plateColor = "蓝色";
                break;
            case 2:
                plateColor = "黄色";
                break;
            case 3:
                plateColor = "白色";
                break;
            case 4:
                plateColor = "黑色";
                break;
            case 5:
                plateColor = "绿色";
                break;
            default:break;
        }
        return plateColor;
    }

    /**
     * 车牌颜色 1：蓝色；2：黄色；3：白色；4：黑色；5：绿色
     */
    public static Integer getPlateColor(String plateColor){
        if (TextUtils.isEmpty(plateColor)){
            return 1;
        }
        Integer plateColorType = 1;
        switch (plateColor){
            case "蓝色":
                plateColorType = 1;
                break;
            case "黄色":
                plateColorType = 2;
                break;
            case "白色":
                plateColorType = 3;
                break;
            case "黑色":
                plateColorType = 4;
                break;
            case "绿色":
                plateColorType = 5;
                break;
            default:break;
        }
        return plateColorType;
    }
}
