package com.icetech.park.domain.entity.month;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

/**
 * 月卡押金记录表
 * Description : 月卡押金记录表实体
 */
@Data
@TableName(value = "`ice_month_deposit_record`")
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class MonthDepositRecord implements Serializable {
    /**
     * 主键自增长id
     */
    @TableId(value = "`id`")
    protected Integer id;

    /**
     * 月卡id
     */
    @TableField(value = "`month_id`")
    protected Integer monthId;

    /**
     * 月卡产品id
     */
    @TableField(value = "`product_id`")
    protected Integer productId;

    /**
     * 车场id
     */
    @TableField(value = "`park_id`")
    protected Integer parkId;

    /**
     * 开卡ID
     */
    @TableField(value = "`order_id`")
    protected Integer orderId;

    /**
     * 申办性质
     */
    @TableField(value = "`card_property`")
    protected Integer cardProperty;

    /**
     * 月卡所属人姓名/公司名称
     */
    @TableField(value = "`card_owner`")
    protected String cardOwner;

    /**
     * 车牌号多个英文,隔开
     */
    @TableField(value = "`plate_num`")
    protected String plateNum;

    /**
     * 车位号多个英文,隔开
     */
    @TableField(value = "`space_num`")
    protected String spaceNum;

    /**
     * 区域id多个英文,隔开
     */
    @TableField(value = "`region_id`")
    protected String regionId;

    /**
     * 手机号码
     */
    @TableField(value = "`phone`")
    protected String phone;

    /**
     * 操作类型1 新增 2 续费 3 修改 4 退卡
     */
    @TableField(value = "`card_opertype`")
    protected Integer cardOpertype;

    /**
     * 是否逾期(仅当操作类型为2时有效 1 是 0 否
     */
    @TableField(value = "`is_overdue`")
    protected Integer isOverdue;

    /**
     * 车位数
     */
    @TableField(value = "`plot_count`")
    protected Integer plotCount;

    /**
     * 购买数量
     */
    @TableField(value = "`count`")
    protected Integer count;

    /**
     * 支付金额
     */
    @TableField(value = "`pay_money`")
    protected BigDecimal payMoney;

    /**
     * 押金
     */
    @TableField(value = "`deposit`")
    protected BigDecimal deposit;

    /**
     * 支付方式(0 现金，1 银行卡 2：微信 3：支付宝)
     */
    @TableField(value = "`pay_method`")
    protected Integer payMethod;

    /**
     * 退卡金额
     */
    @TableField(value = "`refund`")
    protected BigDecimal refund;

    /**
     * 月卡有效开始日期
     */
    @TableField(value = "`start_time`")
    protected Date startTime;

    /**
     * 月卡有效结束日期
     */
    @TableField(value = "`end_time`")
    protected Date endTime;

    /**
     * 操作人
     */
    @TableField(value = "`oper_account`")
    protected String operAccount;

    /**
     * 备注
     */
    @TableField(value = "`remark`")
    protected String remark;

    /**
     * 创建时间
     */
    @TableField(value = "`create_time`")
    protected Date createTime;

    /**
     * 操作时间
     */
    @TableField(value = "`update_time`")
    protected Date updateTime;

    /**
     * 月卡暂停实际开始时间,仅操作类型为暂停和恢复时有效
     */
    @TableField(value = "`cardstop_start`")
    protected Date cardstopStart;

    /**
     * 月卡暂停计划结束时间
     */
    @TableField(value = "`cardstop_end`")
    protected Date cardstopEnd;

    /**
     * 月卡暂停实际结束时间
     */
    @TableField(value = "`cardstop_realyend`")
    protected Date cardstopRealyend;

    /**
     * 月卡额外天数
     */
    @TableField(value = "`add_day`")
    protected String addDay;

    /**
     * 月卡额外收费
     */
    @TableField(value = "`add_amount`")
    protected BigDecimal addAmount;

    /**
     * 车主地址
     */
    @TableField(value = "`main_address`")
    protected String mainAddress;

    /**
     * 支付渠道 1 云平台 2：App 3：公众号
     */
    @TableField(value = "`pay_channel`")
    protected Integer payChannel;

    /**
     * 押金状态(0未退1已退2退返失败，默认0)
     */
    @TableField(value = "`deposit_status`")
    protected Integer depositStatus;

    /**
     * 押金退返时间
     */
    @TableField(value = "`deposit_time`")
    protected Date depositTime;
}