package com.icetech.park.domain.entity.lcd;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

@Data
@TableName(value = "`ice_lcd_tips`")
public class LcdTips implements Serializable {
    /** 主键自增 */
    @TableId(value = "`id`")
    protected Long id;
    /** 停车场id */
    @TableField(value = "`park_id`")
    protected Long parkId;
    /** 出入口通道id(出入口表自增ID) */
    @TableField(value = "`channel_id`")
    protected Long channelId;
    /** 入场临时车/特殊车辆，默认：欢迎光临 */
    @TableField(value = "`enter_tmp_special`")
    protected String enterTmpSpecial;
    /** 入场月卡车/内部车，默认：欢迎光临 */
    @TableField(value = "`enter_month_vip`")
    protected String enterMonthVip;
    /** 入场临时车禁止入场，默认：非月卡车禁止入内 */
    @TableField(value = "`enter_not_allow_tmp_run`")
    protected String enterNotAllowTmpRun;
    /** 入场多卡多车情况，车位被占用提示，默认：车位已占 */
    @TableField(value = "`enter_multi_park_car`")
    protected String enterMultiParkCar;
    /** 入场黑名单提示，默认：禁止通行 */
    @TableField(value = "`enter_black_car`")
    protected String enterBlackCar;
    /** 入场月卡过期提示，默认：月卡车已过期 */
    @TableField(value = "`enter_month_expire`")
    protected String enterMonthExpire;
    /** 入场没有空车位提示信息，默认：车位已满 禁止入内 */
    @TableField(value = "`enter_no_parking_space`")
    protected String enterNoParkingSpace;
    /** 无牌车入场提示，默认：请扫码入场 */
    @TableField(value = "`enter_not_allow_nocar_run`")
    protected String enterNotAllowNocarRun;
    /** 出场缴费提示，默认：请扫码缴费 */
    @TableField(value = "`exit_pay`")
    protected String exitPay;
    /** 出场开闸提示，默认：一路平安 */
    @TableField(value = "`exit_open_gate`")
    protected String exitOpenGate;
    /** 出场无在场记录，默认：无入场信息/请呼叫管理员 */
    @TableField(value = "`exit_no_enterinfo`")
    protected String exitNoEnterinfo;
    /** 无牌车出场，默认：请扫码出场 */
    @TableField(value = "`exit_no_carplate`")
    protected String exitNoCarplate;
    /** 车辆禁止出场提示，默认：禁止通行 */
    @TableField(value = "`exit_not_allow_run`")
    protected String exitNotAllowRun;
    /** 更新时间 */
    @TableField(value = "`update_time`")
    protected Date updateTime;
    /** 更新人 */
    @TableField(value = "`update_user`")
    protected String updateUser;
    /** 入口欠费追缴，默认：您的爱车有欠费，扫码支付后才能入场 */
    @TableField(value = "`enter_unpaid`")
    protected String enterUnpaid;
    /** 出口欠费追缴，默认：您的爱车有欠费，请与本次订单一起完成支付 */
    @TableField(value = "`exit_unpaid`")
    protected String exitUnpaid;
    /** 入场虚假车牌提示，默认：无法识别该车牌，请联系车场管理方 */
    @TableField(value = "`enter_sham_plate`")
    protected String enterShamPlate;
    /** 出场虚假车牌提示，默认：无法识别该车牌，请联系车场管理方 */
    @TableField(value = "`exit_sham_plate`")
    protected String exitShamPlate;
}
