package com.icetech.park.domain.entity.lcd;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

@Data
@TableName(value = "`ice_lcd_show`")
public class LcdShow implements Serializable {
    /** 主键自增 */
    @TableId(value = "`id`")
    protected Long id;
    /** 停车场id */
    @TableField(value = "`park_id`")
    protected Long parkId;
    /** 出入口通道id(出入口表自增ID) */
    @TableField(value = "`channel_id`")
    protected Long channelId;
    /** 显示类型 1：入口空闲显示、2：入场显示、3：出口空闲显示、4：出场显示 */
    @TableField(value = "`display_type`")
    protected Integer displayType;
    /** 显示在第几行，1：第一行、2：第二行、3：第三行、4：第四行，目前最多有4行 */
    @TableField(value = "`row_num`")
    protected Integer rowNum;
    /** 显示颜色1：红色，2：绿色，3：黄色，默认第一、三行是1（红色），二、四行时2（绿色） */
    @TableField(value = "`row_color`")
    protected Integer rowColor;
    /** 动态内容编号和显示序号，多个之间用”+”符号链接，编号和序号之间用”_”符号链接，动态内容有：1：当前时间、2：今日限号、3：剩余车位、4：车牌号、5：车辆类型、6：月卡剩余天数、7：停车时长、8：入场提示、9：缴费/出场提示、10：需支付金额、11：停车场名称、12：储值卡余额（比如：”4_1+5_3”,动态内容需要显示车牌号和车辆类型，车牌号排第一显示，车辆类型排第三显示） */
    @TableField(value = "`dynamic_content`")
    protected String dynamicContent;
    /** 自定义内容和显示序号，多个之间用”+”符号链接，内容和序号之间用”_”符号链接(比如”一路平安_2+注意安全_4”,自定义内容中一路平安排第二显示，注意安全排第四显示) */
    @TableField(value = "`custom_content`")
    protected String customContent;
    /** 更新时间 */
    @TableField(value = "`update_time`")
    protected Date updateTime;
    /** 更新人 */
    @TableField(value = "`update_user`")
    protected String updateUser;

    public enum DisplayTypeEnum {
        入口空闲显示(1), 入场显示(2), 出口空闲显示(3), 出场显示(4);
        public int type;
        private DisplayTypeEnum(int type){
            this.type = type;
        }
    }
    public enum ShowLayoutEnum {
        自定义屏显提示(1), 自定义屏显提示加广告(2), 全屏广告(3);
        public int val;
        private ShowLayoutEnum(int val){
            this.val = val;
        }
    }

    public enum VariateEnum {
        当前时间(1), 今日限号(2), 剩余车位(3), 车牌号(4),
        车辆类型(5), 月卡剩余天数(6), 停车时长(7), 入场提示(8),
        缴费_出场提示(9), 需支付金额(10), 停车场名称(11),
        ;
        public int type;
        private VariateEnum(int type){
            this.type = type;
        }
    }
}
