package com.icetech.park.domain.entity.invoice;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
/**
 * 发票-商户信息表
 * @author fangct
 */
@Getter
@Setter
@ToString
public class InvoiceMerchant implements Serializable {
    private Integer id;

    private String taxpayerNum;

    private String taxpayerName;

    /** 税收分类编码 */
    private String taxCode;
    /** 税率 */
    private Double taxRate;

    private String legalPersonName;

    private String contactsName;

    private String phone;

    private String email;

    private String provinceName;

    private String cityName;

    private String address;

    private String taxRegistrationCertificate;

    private Integer status;

    private String clientName;

    private String clientAddress;

    private String clientPhone;

    private String platformCode;

    private String registrationCode;

    private String authorizationCode;

    private String expressName;

    private String expressNo;

    private Integer channel;

    private Date createTime;

    private Date updateTime;

    private String cardId;

    private String machineNo;
    private String bankName;
    private String bankNum;
    /** 税率标识(0-普通;1-免税;2-简易征收;) */
    private Integer isFreeTax;
    private String extra;

    public String getAllAddress(){
        return this.provinceName+this.cityName+this.address;
    }
}
