package com.icetech.park.domain.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;

import java.io.Serializable;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 工单流转明细表
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2023-11-24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("ice_work_order_transition_detail")
@AllArgsConstructor
@Builder
public class WorkOrderTransitionDetail implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 工单id
     */
    private Long workOrderId;

    /**
     * 0;待处理;1处理中;2已完成;3已取消;4:已退单
     */
    private Integer preStatus;

    /**
     * 当前状态:0;待处理;1处理中;2已完成;3已取消;4:已退单
     */
    private Integer currentStatus;

    /**
     * 触发事件
     */
    private Integer eventAction;

    /**
     * 操作人
     */
    private String operator;

    /**
     * 取消原因
     */
    private String cancelReason;

    /**
     * 文本描述
     */
    private String textDesc;

    /**
     * 图片描述
     */
    private String pictureDesc;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 修改时间
     */
    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;


}
