package com.icetech.park.domain.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 虚假车牌记录表
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author fangct
 * @version 1.0 @date 2023-07-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("ice_sham_plate")
public class ShamPlate implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 主键自增长id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 车场id
     */
    private Long parkId;

    /**
     * 虚假车牌号
     */
    private String plateNum;

    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 出入口类型(1入口2出口)
     */
    private Integer exType;
    /**
     * 车辆类型(1临时车2月卡车3特殊车辆，默认1)
     */
    private Integer type;

    /**
     * 报警时间
     */
    private Date alarmTime;

    /**
     * 通道名称
     */
    private String channelName;

    /**
     * 关联车牌号
     */
    private String relPlateNum;

    /**
     * 虚假车辆照片
     */
    private String carImage;

    /**
     * 关联车辆照片
     */
    private String relCarImage;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;


    @TableField(exist = false)
    private String channelCode;
}
