package com.icetech.park.domain.entity;

import lombok.Data;

import java.util.Date;

/**
 * <p>
 * 遥控器开闸现金收费记录表
 * </p>
 *
 * @author fangct
 * @since 2019-11-25
 */
@Data
public class RemotePay {

    private static final long serialVersionUID = 1L;

    /**
     * 主键自增长id
     */
    private Integer id;

    /**
     * 停车场id
     */
    private Long parkId;

    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 交易流水号
     */
    private String tradeNo;

    /**
     * 支付时间
     */
    private Long payTime;

    /**
     * 上次交费时间
     */
    private Long lastPayTime;

    /**
     * 应收金额
     */
    private String totalPrice;

    /**
     * 实收金额
     */
    private String paidPrice;

    /**
     * 优惠金额
     */
    private String discountPrice;

    /**
     * 缴费方式1现金，2微信，3支付宝，4银联
     */
    private Integer payWay;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    private Date createTime;


}
