package com.icetech.park.domain.entity;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 车场托管缴费记录
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2023-06-28
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("ice_park_trusteeship_record")
public class ParkTrusteeshipRecord implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 主键自增长id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 车场id
     */
    private Long parkId;

    /**
     * 所属机构
     */
    private Integer institutionId;

    /**
     * 通道数量
     */
    private Integer channelNum;

    /**
     * 托管模式：1-甲方自建坐席托管，2-知位自营坐席托管
     */
    private Integer trusteeshipModel;

    /**
     * 托管价格 元 / 单通道.月 ）
     */
    private BigDecimal unitPrice;

    /**
     * 托管时长（月）
     */
    private Integer duration;

    /**
     * 有效开始日期
     */
    private Date startTime;

    /**
     * 有效结束日期
     */
    private Date endTime;

    /**
     * 服务费支付金额
     */
    private BigDecimal payAmount;

    /**
     * 支付方式，1-现金，2-微信，3-支付宝
     */
    private Integer payMethod;

    /**
     * 缴费类型，1-开通托管服务，2-托管续费
     */
    private Integer payType;

    /**
     * 1-有效
     */
    private Integer status;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;

    /**
     * 操作人
     */
    private String operator;


}
