package com.icetech.park.domain.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 车牌二次识别
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2021-07-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("ice_iot_plate")
public class IotPlate implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * iD (主健自增)
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 记录类型（1:进场;2:出场）
     */
    private Integer recordType;

    /**
     * 车场id
     */
    private Integer parkId;

    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * iot识别的车牌号
     */
    private String plateNumIot;

    /**
     * iot返回的置信度，范围在0到100之间，依次是由低到高
     */
    private String reliabilityIot;

    /**
     * 相机返回的置信度，范围在0到28之间，依次是由低到高
     */
    private Integer reliabilityIce;

    /**
     * 相机返回的置信度，范围在0到100之间，依次是由低到高
     */
    private String reliabilityIce1;

    /**
     * 图片
     */
    private String image;

    /**
     *  进场小图片
     */
    private String smallEnterImage;

    /**
     * 车辆类型
     */
    private String clsName;

    /**
     * 车辆类型置信度
     */
    private String clsProb;

    /**
     * 通道编号
     */
    private String channelCode;

    /**
     * 其他
     */
    private String remark;

    /**
     * 状态0未检测,1已检测成功2检测失败
     */
    private Integer status;

    /**
     * 通知java接口状态 1成功2失败
     */
    private Integer sendStatus;

    /**
     * 识别结果:1:一致2:不一致
     */
    private Boolean result;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 识别时间
     */
    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;

    /**
     * 二次识别测次数
     */
    private Integer checkNum;

    /**
     * 车辆状态(1在场2离场)
     */
    private Integer parkcarStatus;


}
