package com.icetech.order.service.impl;

import java.util.List;

import com.icetech.cloudcenter.api.order.OrderTrackService;
import com.icetech.order.dao.OrderTrackMapper;
import com.icetech.order.domain.entity.OrderTrack;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import org.springframework.stereotype.Service;

@Service("orderTrackService")
public class OrderTrackServiceImpl extends BaseServiceImpl<OrderTrackMapper, OrderTrack> implements OrderTrackService {
    @Override
    public List<OrderTrack> getTracksByOrder(Long parkId, String orderNum) {
        return list(getLambdaQueryWrapper()
                .eq(OrderTrack::getParkId, parkId)
                .eq(OrderTrack::getOrderNum, orderNum)
                .orderByAsc(OrderTrack::getEnexTime));
    }
}
