package com.icetech.order.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.google.common.collect.Lists;
import com.icetech.cloudcenter.api.order.OrderMoneyService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.response.WorkRecordDto;
import com.icetech.cloudcenter.domain.response.WorkReportDto;
import com.icetech.order.dao.OrderMoneyDao;
import com.icetech.order.dao.OrderPayDao;
import com.icetech.order.dao.ReportBclientDao;
import com.icetech.basics.dao.park.ParkConfigDao;
import com.icetech.user.dao.SaasUserDao;
import com.icetech.user.dao.SaasUserParkMapper;
import com.icetech.user.dao.WorkReportDao;
import com.icetech.order.domain.entity.OrderMoney;
import com.icetech.order.domain.entity.ReportBclient;
import com.icetech.cloudcenter.domain.order.SumOrderMoneyDto;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.user.domain.entity.user.SaasUser;
import com.icetech.user.domain.entity.user.WorkReport;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;
import java.util.Objects;

@Slf4j
@Service("orderMoneyService")
public class OrderMoneyServiceImpl implements OrderMoneyService {
    @Autowired
    private SaasUserDao saasUserDao;
    @Autowired
    private SaasUserParkMapper saasUserParkMapper;
    @Autowired
    private ParkService parkService;
    @Autowired
    private WorkReportDao workReportDao;
    @Autowired
    private OrderPayDao orderPayDao;
    @Autowired
    private ReportBclientDao reportBclientDao;
    @Autowired
    private OrderMoneyDao orderMoneyDao;
    @Autowired
    private ParkConfigDao parkConfigDao;

    @Override
    public ObjectResponse addWorkReports(Integer userId) {
        try {
            //查询用户下的所有车场信息
            List<Long> parkIds = saasUserParkMapper.selectParkIdsByUserId(userId);
            if (!CollectionUtils.isEmpty(parkIds)){
                List<WorkReport> workReports = Lists.newArrayList();
                List<Long> unReportParkIds = workReportDao.selectUnReport(parkIds,userId);
                if (CollectionUtils.isEmpty(unReportParkIds)){
                    unReportParkIds = Lists.newArrayList();
                }
                //如果车场没有未结账的信息则添加未结账信息
                for(Long parkId:parkIds){
                    if (!unReportParkIds.contains(parkId)){
                        WorkReport newWorkReport = new WorkReport();
                        newWorkReport.setParkId(Math.toIntExact(parkId));
                        newWorkReport.setUserId(userId);
                        newWorkReport.setWorkOnTime(new Date());
                        newWorkReport.setIsReport(Boolean.FALSE);
                        newWorkReport.setCreateTime(new Date());
                        workReports.add(newWorkReport);
                    }
                }

                if (!CollectionUtils.isEmpty(workReports)){
                    workReportDao.batchInsert(workReports);
                }
            }

        }catch (Exception e){
            log.error("[添加结账记录失败]|e=",e);
        }
        return ObjectResponse.success();
    }

    @Override
//    @Transactional
    @DSTransactional
    public ObjectResponse<WorkRecordDto> getParkReportMoney(Integer userId, String parkCode) {
        if (StringUtils.isBlankOrNullChar(parkCode)) {
            return ObjectResponse.failed(CodeConstants.ERROR_400, "车场编号不存在");
        }
        //获取车场信息
        Park park = parkService.findByParkCode(parkCode).getData();
        if (park == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_400, "车场编号不存在");
        }
        //获取用户信息
        SaasUser saasUser = saasUserDao.load(userId);

        //获取当前登陆人员的上班时间
        WorkReport workReport = workReportDao.selectByWorkOn(userId, Math.toIntExact(park.getId()));
        //按时间统计结账金额
        if (Objects.nonNull(workReport)){
            String endTime = DateTools.getFormat(new Date());
            SumOrderMoneyDto sumOrderMoneyDto = orderPayDao.selectMoneyCountByTime(workReport.getWorkOnTime(), workReport.getId(), Math.toIntExact(park.getId()), endTime);
            //封装返回参数
            WorkRecordDto workRecordDto = new WorkRecordDto();
            workRecordDto.setUserName(saasUser.getUsername());
            workRecordDto.setWorkOnTime(workReport.getWorkOnTime());
            workRecordDto.setReportPrice(sumOrderMoneyDto.getPaidPrice());
            workRecordDto.setDiscountPrice(sumOrderMoneyDto.getDiscountPrice());
            workRecordDto.setTotalPrice(sumOrderMoneyDto.getTotalPrice());
            workRecordDto.setPayNum(sumOrderMoneyDto.getCountNUm());
            workRecordDto.setEndTime(endTime);
            workRecordDto.setUnits(parkConfigDao.selectByParkId(park.getId()).getMoneyunitType());
            return ObjectResponse.success(workRecordDto);
        }else {
            WorkRecordDto workRecordDto = new WorkRecordDto();
            workRecordDto.setUserName(saasUser.getUsername());
            return ObjectResponse.success( workRecordDto);
        }

    }
//    @Transactional
    @DSTransactional
    @Override
    public ObjectResponse settleAccounts(Integer userId, String parkCode, String endTime, Integer from) {
        //获取车场信息
        Park park = parkService.findByParkCode(parkCode).getData();
        if (park == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_400);
        }
        //获取用户信息
        SaasUser saasUser = saasUserDao.load(userId);
        //获取当前登陆人员的上班时间
        WorkReport workReport = workReportDao.selectByWorkOn(userId, Math.toIntExact(park.getId()));
        if (Objects.nonNull(workReport)){
            SumOrderMoneyDto sumOrderMoneyDto = orderPayDao.selectMoneyCountByTime(workReport.getWorkOnTime(), workReport.getId(), Math.toIntExact(park.getId()), endTime);
            workReport.setIsReport(Boolean.TRUE);
            workReport.setWorkOffTime(new Date());
            workReport.setReportPrice(sumOrderMoneyDto.getPaidPrice());
            workReport.setUpdateTime(new Date());
            workReportDao.updateByPrimaryKeySelective(workReport);
            log.info("[现金结账接口]更新完成. info[{}]",JsonUtils.toString(workReport));
            //添加现金缴费的报表信息
            ReportBclient reportBclient = new ReportBclient();
            reportBclient.setParkId(park.getId());
            reportBclient.setName(saasUser.getName());
            reportBclient.setType(from);
            reportBclient.setCharge(sumOrderMoneyDto.getTotalPrice());
            reportBclient.setRealcharge(sumOrderMoneyDto.getPaidPrice());
            reportBclient.setDisamount(sumOrderMoneyDto.getDiscountPrice());
            reportBclient.setUsername(saasUser.getUsername());
            reportBclient.setStartTime(workReport.getWorkOnTime());
            reportBclient.setEndTime(workReport.getWorkOffTime());
            reportBclient.setPayNum(sumOrderMoneyDto.getCountNUm());
            reportBclient.setAmount(sumOrderMoneyDto.getPaidPrice());
            reportBclientDao.insert(reportBclient);
            return ObjectResponse.success();
        }
        return ObjectResponse.failed(CodeConstantsEnum.ERROR_404.getCode(),"结账失败");
    }

    @Override
    public ObjectResponse<WorkReportDto> getWorkReport(Integer userId, Long parkId) {
        //获取当前登陆人员的上班时间
        WorkReport workReport = workReportDao.selectByWorkOn(userId, Math.toIntExact(parkId));
        if (workReport != null){
            WorkReportDto workReportDto = new WorkReportDto();
            BeanUtils.copyProperties(workReport, workReportDto);
            return ObjectResponse.success(workReportDto);
        }else{
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
    }

    @Override
    public ObjectResponse addOrderMoney(Integer reportId, Long orderPayId) {
        OrderMoney orderMoney = new OrderMoney();
        orderMoney.setOrderPayId(orderPayId.intValue());
        orderMoney.setReportId(reportId);
        orderMoneyDao.insert(orderMoney);
        return ObjectResponse.success();
    }
}
