package com.icetech.order.service.impl;

import com.icetech.cloudcenter.api.discount.DiscountService;
import com.icetech.common.constants.CodeConstants;
import com.icetech.order.dao.OrderDiscountDao;
import com.icetech.order.domain.entity.OrderDiscount;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.PageQuery;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Slf4j
@Service("discountService")
public class DiscountServiceImpl implements DiscountService {
    @Autowired
    private OrderDiscountDao orderDiscountDao;

    @Override
    public ObjectResponse<List<OrderDiscount>> findList(PageQuery<OrderDiscount> pageQuery) {
        if (pageQuery.getParam() == null){
            return ObjectResponse.failed(CodeConstants.ERROR_400);
        }else{
            List<OrderDiscount> orderPays = orderDiscountDao.selectListByPage(pageQuery);
            return ObjectResponse.success(orderPays);
        }
    }
}
