package com.icetech.order.service.impl;

import com.icetech.cloudcenter.api.IBatchDownSendService;
import com.icetech.third.service.third.MqPushService;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.validator.Validator;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 删除业务数据
 *
 * @author fangct
 * @date 2021/11/12
 */
@Slf4j
@Service
public class BatchDownSendServiceImpl implements IBatchDownSendService {
    @Autowired
    private MqPushService mqPushService;

    @Override
    public ObjectResponse execute(List<SendRequest> sendRequestList) {
        for (SendRequest sendRequest : sendRequestList) {
            if (!Validator.validate(sendRequest)) {
                return ObjectResponse.failed(CodeConstants.ERROR_400);
            }
        }
        Map<Long, List<SendRequest>> parkListMap = sendRequestList.stream()
                .collect(Collectors.groupingBy(SendRequest::getParkId));
        Set<Long> parkSet = parkListMap.keySet();
        for (Long parkId : parkSet) {
            List<SendRequest> sendRequests = parkListMap.get(parkId);
            try {
                mqPushService.pushBatchDownSend(parkId, sendRequests);
            } catch (Exception e) {
                log.error("批量下发异常, 参数[{}]", sendRequestList, e);
                return ObjectResponse.failed("发送mq消息异常");
            }
        }
        return ObjectResponse.success();
    }
}
