package com.icetech.order.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.icetech.basics.domain.entity.park.BasePark;
import com.icetech.basics.service.park.impl.ParkServiceImpl;
import com.icetech.common.domain.Page;
import com.icetech.order.domain.dto.BarrierGateExceptionDTO;
import com.icetech.order.domain.entity.BarrierGateException;
import com.icetech.order.domain.vo.BarrierGateExceptionVO;
import com.icetech.order.service.BarrierGateExceptionService;
import com.icetech.order.service.BarrierGateGroupService;
import com.icetech.oss.OssService;
import com.icetech.park.domain.entity.park.Park;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @description: TODO
 * @auth: wangzhiwei
 * @date: 2023-08-01  09:59
 * @Version: 1.0
 */
@Service
@Slf4j
public class BarrierGateGroupServiceImpl implements BarrierGateGroupService {
    @Resource
    private BarrierGateExceptionService barrierGateExceptionService;
    @Resource
    private ParkServiceImpl parkService;
    @Resource
    private OssService ossService;
    @Override
    public Page<BarrierGateExceptionVO> listPage(BarrierGateExceptionDTO queryDTO, List<Long> parkIds) {
        Page<BarrierGateException> pageList = barrierGateExceptionService.getPageList(queryDTO, parkIds);
        Page<BarrierGateExceptionVO> voPage = new Page<>();
        BeanUtil.copyProperties(pageList,voPage);
        if (Objects.nonNull(pageList) && CollectionUtils.isNotEmpty(pageList.getRows())) {
            Set<Long> parkIdSet = pageList.getRows().stream().map(BarrierGateException::getParkId).collect(Collectors.toSet());
            Map<Long, BasePark> parkMap = parkService.listByIds(parkIdSet).stream().collect(Collectors.toMap(BasePark::getId, Function.identity()));
            List<BarrierGateExceptionVO> exceptionVOS = pageList.getRows().stream().map(t->{
                BarrierGateExceptionVO vo = new BarrierGateExceptionVO();
                BeanUtil.copyProperties(t,vo);
                if (queryDTO.getLoadImage()){
                    vo.setExceptionImage(ossService.getImageUrl(vo.getExceptionImage()));
                    vo.setRecoverImage(ossService.getImageUrl(vo.getRecoverImage()));
                }
                BasePark basePark = parkMap.get(t.getParkId());
                if (Objects.nonNull(basePark)){
                    vo.setParkCode(basePark.getParkCode());
                    vo.setParkName(basePark.getParkName());
                }
                return vo;
            }).collect(Collectors.toList());
            voPage.setRows(exceptionVOS);
        }
        return voPage;
    }

    @Override
    public BarrierGateExceptionVO detail(Long recordId, Long parkId) {
        BarrierGateException barrierGateException = barrierGateExceptionService.getById(recordId);
        if (barrierGateException == null){
            return null;
        }
        if (!Objects.equals(barrierGateException.getParkId(), parkId)) return null;
        BarrierGateExceptionVO vo = new BarrierGateExceptionVO();
        BeanUtil.copyProperties(barrierGateException,vo);
        Park basePark = parkService.findByParkId(parkId).getData();
        if (Objects.nonNull(basePark)){
            vo.setParkCode(basePark.getParkCode());
            vo.setParkName(basePark.getParkName());
        }
        vo.setExceptionImage(ossService.getImageUrl(vo.getExceptionImage()));
        return vo;
    }
}
