package com.icetech.order.service;

import com.icetech.order.domain.entity.ReenterRecord;
import com.icetech.db.mybatis.base.service.IBaseService;

/**
 * 重复入场记录表 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author fangct
 * @version 1.0 @date 2023-03-08
 */
public interface ReenterRecordService extends IBaseService<ReenterRecord> {

    /**
     * Description: 根据ID查询 重复入场记录表对象信息 <br>
     * Version1.0 2023-03-08 by fangct创建
     *
     * @param id 对象id
     * @return ReenterRecord
     */
    ReenterRecord getReenterRecordById (Long id);

    /**
     * Description: 新增  重复入场记录表对象信息 <br>
     * Version1.0 2023-03-08 by fangct创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addReenterRecord (ReenterRecord entity);

    /**
     * Description: 修改 重复入场记录表对象信息 <br>
     * Version1.0 2023-03-08 by fangct创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyReenterRecord (ReenterRecord entity);

    /**
     * Description: 删除  重复入场记录表对象信息 <br>
     * Version1.0 2023-03-08 by fangct创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeReenterRecordById (Long id);
}
