package com.icetech.order.service;

import com.icetech.db.mybatis.base.service.IBaseService;
import com.icetech.order.domain.entity.OrderRemark;

/**
 * 订单备注表 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2024-01-05
 */
public interface OrderRemarkService extends IBaseService<OrderRemark> {

    /**
     * Description: 根据ID查询 订单备注表对象信息 <br>
     * Version1.0 2024-01-05 by wanggang创建
     *
     * @param id 对象id
     * @return OrderRemark
     */
    OrderRemark getOrderRemarkById (Long id);

    /**
     * Description: 新增  订单备注表对象信息 <br>
     * Version1.0 2024-01-05 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addOrderRemark (OrderRemark entity);

    /**
     * Description: 修改 订单备注表对象信息 <br>
     * Version1.0 2024-01-05 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyOrderRemark (OrderRemark entity);

    /**
     * Description: 删除  订单备注表对象信息 <br>
     * Version1.0 2024-01-05 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeOrderRemarkById (Long id);

    /**
     * 根据订单号和类型获取备注信息
     *
     * @param orderNum
     * @param type
     * @return
     */
    OrderRemark getByOrderNumAndType(String orderNum, Integer type);
}
