package com.icetech.order.service;

import com.icetech.common.domain.Page;
import com.icetech.order.domain.entity.OrderNotpay;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.order.domain.vo.CountVO;
import com.icetech.order.domain.vo.NotPayPage;
import com.icetech.order.domain.dto.NotPayRecordQueryDTO;
import com.icetech.cloudcenter.domain.vo.NotPayDetailVo;
import com.icetech.db.mybatis.base.service.IBaseService;

import java.util.List;

/**
 * 订单欠费记录表 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author fangct
 * @version 1.0 @date 2023-03-08
 */
public interface OrderNotpayService extends IBaseService<OrderNotpay> {
    /**
     * 欠费记录查询
     * @param parkId 车场ID
     * @param plateNum 车牌号
     * @return NotPayOrderDTO
     */
    List<OrderNotpay> queryNotPayFee(Long parkId, String plateNum, Integer exType);
    List<OrderNotpay> queryNotPayFee(Long parkId, String plateNum, Integer exType, ParkConfig parkConfig);

    /**
     * Description: 根据ID查询 订单欠费记录表对象信息 <br>
     * Version1.0 2023-03-08 by fangct创建
     *
     * @param id 对象id
     * @return OrderNotpay
     */
    OrderNotpay getOrderNotpayById (Long id);

    /**
     * Description: 新增  订单欠费记录表对象信息 <br>
     * Version1.0 2023-03-08 by fangct创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addOrderNotpay (OrderNotpay entity);

    /**
     * Description: 处理订单
     * Version1.0 2023-03-23 by wgy 创建
     *
     * @param orderNotpay      对象
     * @return java.lang.Boolean
     */
    Boolean dealNotpayOrder(OrderNotpay orderNotpay);

    /**
     * Description: 订单编号查询补缴信息
     * Version1.0 2023-03-27 by wgy 创建
     *
     * @param orderNum  订单号
     * @return com.icetech.cloudcenter.domain.entity.order.OrderNotpay
     */
    OrderNotpay getOrderNotpayByOrderNum(String orderNum);
    List<OrderNotpay> getListByOrderNums(List<String> orderNums);

    /**
     * Description: 统计车场的补缴金额
     * Version1.0 2023-07-28 by wgy 创建
     *
     * @param status    状态
     * @param month     月份
     * @return java.util.List<com.icetech.order.domain.entity.OrderNotpay>
     */
    List<OrderNotpay> getPaidPriceGroupParkId(Integer status, String month);

    /**
     * Description: 分页查询订单
     * Version1.0 2023-03-27 by wgy 创建
     *
     * @param queryDTO  查询参数
     * @param parkIds    车场id
     * @return com.icetech.order.domain.vo.NotPayPage<com.icetech.cloudcenter.domain.entity.order.OrderNotpay>
     */
    Page<OrderNotpay> getNotPayRecord(NotPayRecordQueryDTO queryDTO, List<Long> parkIds);

    /**
     * 仅仅统计数量与金额
     * @param queryDTO
     * @param parkIds
     * @return
     */
    CountVO getTotal(NotPayRecordQueryDTO queryDTO, List<Long> parkIds);

    /**
     * 根据订单号删除追缴记录
     * @param orderNum
     * @return
     */
    Boolean deleteByOrderNum(String orderNum);

    /**
     * 欠费追缴
     * @param vos
     * @param channelCode
     */
    void updatePaidByOrderNums(List<NotPayDetailVo> vos, String channelCode,String operAccount);

    /**
     * 大额订单
     * @param notPay 待支付
     */
    void largeOrder(OrderNotpay notPay);

}
