package com.icetech.order.service;

import com.icetech.common.domain.Page;
import com.icetech.order.domain.vo.CountVO;
import com.icetech.order.domain.vo.NotPayPage;
import com.icetech.order.domain.dto.NotPayRecordQueryDTO;
import com.icetech.order.domain.vo.OrderNotpayVO;

import java.util.List;

/**
 * @description: 跟车逃费聚合接口
 * @auth: wangzhiwei
 * @date: 2023-07-28  10:19
 * @Version: 1.0
 */
public interface OrderNotpayGroupService {


    /**
     * 分页列表
     * @param notPayRecordQueryDTO
     * @return
     */
    Page<OrderNotpayVO> listPage(NotPayRecordQueryDTO notPayRecordQueryDTO, List<Long> parkIds);

    /**
     * 仅仅汇总
     * @param notPayRecordQueryDTO
     * @param parkIds
     * @return
     */
    CountVO count(NotPayRecordQueryDTO notPayRecordQueryDTO, List<Long> parkIds);

    /**
     * 详情
     * @param recordId
     * @param parkId
     * @return
     */
    OrderNotpayVO detail(Long recordId, Long parkId);
}
