package com.icetech.order.service;


import com.icetech.common.domain.Page;
import com.icetech.db.mybatis.base.service.IBaseService;
import com.icetech.order.domain.dto.OrderBackQueryDTO;
import com.icetech.order.domain.entity.OrderBack;
import com.icetech.order.domain.vo.CountVO;

import java.util.List;

/**
 * 折返回场记录表 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author fangct
 * @version 1.0 @date 2023-07-20
 */
public interface OrderBackService extends IBaseService<OrderBack> {

    /**
     * Description: 根据ID查询 折返回场记录表对象信息 <br>
     * Version1.0 2023-07-20 by fangct创建
     *
     * @param id 对象id
     * @return OrderBack
     */
    OrderBack getOrderBackById (Long id);

    /**
     * Description: 新增  折返回场记录表对象信息 <br>
     * Version1.0 2023-07-20 by fangct创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addOrderBack (OrderBack entity);

    /**
     * Description: 修改 折返回场记录表对象信息 <br>
     * Version1.0 2023-07-20 by fangct创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyOrderBack (OrderBack entity);

    /**
     * Description: 删除  折返回场记录表对象信息 <br>
     * Version1.0 2023-07-20 by fangct创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeOrderBackById (Long id);

    /**
     * 分页查询列表
     * @param queryDTO
     * @param parkIds
     * @return
     */
    Page<OrderBack> getPageList(OrderBackQueryDTO queryDTO, List<Long> parkIds);

    /**
     * 统计
     * @param queryDTO
     * @param parkIds
     * @return
     */
    Integer getTotal(OrderBackQueryDTO queryDTO, List<Long> parkIds);

    /**
     * 通过订单号获取折返列表
     *
     * @param orderNum 订单号
     * @return
     */
    List<OrderBack> getListByOrderNum(String orderNum);
}
