package com.icetech.order.dao;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.db.mybatis.base.mapper.SuperMapper;
import com.icetech.order.domain.entity.OrderTags;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * 订单标签关联表 Mapper 接口
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author fangct
 * @version 1.0 @date 2021-11-10
 */
@Mapper
public interface OrderTagsDao extends SuperMapper<OrderTags> {

    default OrderTags selectByOrderNum(String orderNum, Integer tagId, Long regionId) {
        return selectOne(Wrappers.lambdaQuery(OrderTags.class)
                .eq(OrderTags::getOrderNum, orderNum)
                .eq(regionId != null && regionId != 0, OrderTags::getRegionId, regionId)
                .eq(OrderTags::getTagId, tagId));
    }
}