package com.icetech.order.dao;

import java.util.List;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.order.domain.entity.OrderSonCarInfo;
import com.icetech.db.mybatis.base.mapper.SuperMapper;
import org.springframework.stereotype.Repository;

@Repository
public interface OrderSonCarInfoDao extends SuperMapper<OrderSonCarInfo> {
    default OrderSonCarInfo selectByOrderSonId(long orderSonId) {
        OrderSonCarInfo param = new OrderSonCarInfo();
        param.setOrderSonId(orderSonId);
        return selectLimitOne(param);
    }

    default List<OrderSonCarInfo> selectListByOrderNum(String orderNum) {
        return selectList(Wrappers.lambdaQuery(OrderSonCarInfo.class).eq(OrderSonCarInfo::getOrderNum, orderNum));
    }

    default int updateByOrderSonId(OrderSonCarInfo carInfo) {
        Long orderSonId = carInfo.getOrderSonId();
        carInfo.setId(null);
        carInfo.setOrderSonId(null);
        return update(carInfo, Wrappers.lambdaQuery(OrderSonCarInfo.class).eq(OrderSonCarInfo::getOrderSonId, orderSonId));
    }

    int batchSave(List<OrderSonCarInfo> orderSonCarInfos);
}
