package com.icetech.order.dao;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.icetech.order.domain.dto.OrderRefundRecordDTO;
import com.icetech.order.domain.entity.OrderRefundRecord;
import com.icetech.db.mybatis.base.mapper.SuperMapper;

import com.icetech.park.domain.request.RefundRecordParam;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

/**
 * 退款记录表 Mapper 接口
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2022-04-20
 */
@Mapper
public interface OrderRefundRecordMapper extends SuperMapper<OrderRefundRecord> {

    /**
     * 退款记录列表
     *
     * @param page  分 页
     * @param param 参数
     * @return list
     */
    Page<OrderRefundRecordDTO> getOrderRefundRecordList(@Param("page") Page<OrderRefundRecordDTO> page, @Param("param") RefundRecordParam param);

}
