package com.icetech.order.dao;

import java.util.List;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.db.mybatis.base.mapper.SuperMapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface OrderCarInfoDao extends SuperMapper<OrderCarInfo> {
    default OrderCarInfo selectByOrderNum(String orderNum) {
        return selectOne(Wrappers.lambdaQuery(OrderCarInfo.class).eq(OrderCarInfo::getOrderNum, orderNum));
    }

    default int updateByOrderNum(OrderCarInfo carInfo) {
        Long id = carInfo.getId();
        String orderNum = carInfo.getOrderNum();
        carInfo.setId(null);
        carInfo.setOrderNum(null);
        int result = update(carInfo, Wrappers.lambdaUpdate(OrderCarInfo.class).eq(OrderCarInfo::getOrderNum, orderNum));
        carInfo.setId(id);
        carInfo.setOrderNum(orderNum);
        return result;
    }

    /**
     * 查询图片
     *
     * @param orderNums 订单号
     * @return
     */
    List<OrderCarInfo> selectImgByOrderNums(@Param("orderNums") List<String> orderNums);

    OrderCarInfo selectByOrderNumListWithHistory(@Param("orderNum") String orderNum, @Param("tables") List<String> tables);

    /**
     * 更新历史表
     *
     * @param orderCarInfo 详情
     * @param table        历史表名后缀，2024q3
     * @return
     */
    int updateByIdWithHistory(@Param("orderCarInfo") OrderCarInfo orderCarInfo, @Param("table") String table);
}
