package com.icetech.order.dao;

import com.icetech.order.domain.entity.OrderAuthInfo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface OrderAuthDao {
    /**
     * 跟新
     * @param orderAuthInfo
     * @return
     */
    int updateOrderAuth(OrderAuthInfo orderAuthInfo);
    /**
     *
     * @param orderAuthInfo
     * @return
     */
    int insert(OrderAuthInfo orderAuthInfo);
    /**
     * 查询根据订单号
     * @param orderNum
     * @return
     */
    OrderAuthInfo selectByOrderNum(@Param("orderNum") String orderNum,@Param("status") Integer status);
    /**
     * 查询根据授权码
     * @param authNum
     * @return
     */
    OrderAuthInfo selectByAuthNum(@Param("authNum")String authNum);
    /**
     * 查询授权记录
     * @param parkId
     * @param startTime
     * @param endTime
     * @return
     */
    List<OrderAuthInfo> selectAuthRecords(@Param("parkId") String parkId, @Param("startTime") String startTime, @Param("endTime") String endTime,@Param("status") List<Integer> status);
    /**
     * 查询授权记录条数
     * @param parkId
     * @param startTime
     * @param endTime
     * @return
     */
    int countAuthRecords(@Param("parkId") String parkId, @Param("startTime") String startTime, @Param("endTime") String endTime,@Param("status") List<Integer> status);
}
