/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.order.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.order.dao.ShamPlateMapper;
import com.icetech.order.service.ShamPlateService;
import com.icetech.park.domain.entity.ShamPlate;
import com.icetech.third.service.third.MqPushService;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShamPlateServiceImpl
extends BaseServiceImpl<ShamPlateMapper, ShamPlate>
implements ShamPlateService {
    @Autowired
    private MqPushService mqPushService;

    @Override
    public ShamPlate getShamPlateById(Long id) {
        return (ShamPlate)this.getById(id);
    }

    @Override
    public Boolean addShamPlate(ShamPlate entity) {
        boolean result = this.save(entity);
        this.mqPushService.pushShamPlate(entity);
        return result;
    }

    @Override
    public Boolean modifyShamPlate(ShamPlate entity) {
        return this.updateById(entity);
    }

    @Override
    public Boolean removeShamPlateById(Long id) {
        return this.removeById(id);
    }

    @Override
    public com.icetech.common.domain.Page<ShamPlate> getPage(Integer pageNo, Integer pageSize, String plateNum, List<Long> parkIds, String startTime, String endTime) {
        Page page = new Page();
        page.setCurrent((long)pageNo.intValue());
        page.setSize((long)pageSize.intValue());
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery(ShamPlate.class);
        if (CollectionUtils.isNotEmpty(parkIds) && !parkIds.contains(-1L)) {
            queryWrapper.in(ShamPlate::getParkId, parkIds);
        }
        if (StringUtils.isNotBlank((CharSequence)plateNum)) {
            queryWrapper.like(ShamPlate::getPlateNum, (Object)plateNum);
        }
        if (StringUtils.isNotBlank((CharSequence)startTime)) {
            queryWrapper.ge(ShamPlate::getAlarmTime, (Object)startTime);
        }
        if (StringUtils.isNotBlank((CharSequence)endTime)) {
            queryWrapper.le(ShamPlate::getAlarmTime, (Object)endTime);
        }
        queryWrapper.orderByDesc(ShamPlate::getId);
        IPage result = this.page((IPage)page, (Wrapper)queryWrapper);
        return com.icetech.common.domain.Page.instance((int)Math.toIntExact(result.getPages()), (long)result.getTotal(), (List)result.getRecords());
    }

    @Override
    public Long getTotal(String plateNum, List<Long> parkIds, String startTime, String endTime) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery(ShamPlate.class);
        if (CollectionUtils.isNotEmpty(parkIds) && !parkIds.contains(-1L)) {
            queryWrapper.in(ShamPlate::getParkId, parkIds);
        }
        if (StringUtils.isNotBlank((CharSequence)plateNum)) {
            queryWrapper.like(ShamPlate::getPlateNum, (Object)plateNum);
        }
        if (StringUtils.isNotBlank((CharSequence)startTime)) {
            queryWrapper.ge(ShamPlate::getAlarmTime, (Object)startTime);
        }
        if (StringUtils.isNotBlank((CharSequence)endTime)) {
            queryWrapper.le(ShamPlate::getAlarmTime, (Object)endTime);
        }
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    public ShamPlate getShamPlateBy(Long id, String orderNum) {
        if (Objects.isNull(id) && StringUtils.isEmpty((CharSequence)orderNum)) {
            return null;
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery(ShamPlate.class);
        if (Objects.nonNull(id)) {
            queryWrapper.eq(ShamPlate::getId, (Object)id);
        }
        if (StringUtils.isNotEmpty((CharSequence)orderNum)) {
            queryWrapper.eq(ShamPlate::getOrderNum, (Object)orderNum);
        }
        return (ShamPlate)this.selectLimitOne(queryWrapper);
    }

    @Override
    public List<ShamPlate> getShamPlateListByOrderNum(String orderNum) {
        return this.list((Wrapper)Wrappers.lambdaQuery(ShamPlate.class).eq(ShamPlate::getOrderNum, (Object)orderNum));
    }
}

