/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.order.service.impl;

import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.order.dao.OrderTagsDao;
import com.icetech.order.domain.entity.OrderTags;
import com.icetech.order.service.OrderTagsService;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderTagsServiceImpl
extends BaseServiceImpl<OrderTagsDao, OrderTags>
implements OrderTagsService {
    @Autowired
    private OrderTagsDao orderTagsDao;
    private List<Integer> types = Arrays.asList(3, 4, 5, 6);

    @Override
    public OrderTags getListByOrderNumAndTagId(String orderNum, Integer tagId, Long regionId) {
        return this.orderTagsDao.selectByOrderNum(orderNum, tagId, regionId);
    }

    @Override
    public OrderTags getOrderTagsById(Long id) {
        return (OrderTags)this.getById(id);
    }

    @Override
    public Boolean addOrderTags(OrderTags entity) {
        return this.save(entity);
    }

    @Override
    public Boolean modifyOrderTags(OrderTags entity) {
        return this.updateById(entity);
    }

    @Override
    public Boolean removeOrderTagsById(Long id) {
        return this.removeById(id);
    }

    @Override
    public List<OrderTags> getListByOrderNum(String orderNum, Integer type) {
        List tags = this.list(OrderTags.builder().orderNum(orderNum).build());
        if (CollectionUtils.isEmpty((Collection)tags)) {
            return Collections.emptyList();
        }
        if (type != null && type == 0) {
            return tags.stream().filter(Objects::nonNull).filter(orderTag -> orderTag.getTagId() != null).filter(tag -> this.types.contains(tag.getTagId())).collect(Collectors.toList());
        }
        return tags;
    }
}

