/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.order.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.icetech.basics.domain.entity.park.BasePark;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.common.utils.DateTools;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.order.dao.OrderPayDiscountMapper;
import com.icetech.order.domain.dto.PayDiscountListDTO;
import com.icetech.order.domain.entity.OrderPayDiscount;
import com.icetech.order.domain.vo.OrderPayDiscountPageVo;
import com.icetech.order.domain.vo.PayDiscountListVo;
import com.icetech.order.service.OrderPayDiscountService;
import com.icetech.park.domain.entity.park.Park;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderPayDiscountServiceImpl
extends BaseServiceImpl<OrderPayDiscountMapper, OrderPayDiscount>
implements OrderPayDiscountService {
    @Autowired
    private ParkService parkService;

    @Override
    public OrderPayDiscountPageVo<PayDiscountListVo> listPage(PayDiscountListDTO queryDTO) {
        QueryWrapper wrapper = new QueryWrapper();
        if (CollectionUtils.isNotEmpty((Collection)queryDTO.getParkIdList())) {
            wrapper.in((Object)"park_id", (Collection)queryDTO.getParkIdList());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryDTO.getDiscountSources())) {
            wrapper.and(wrapper1 -> {
                if (queryDTO.getDiscountSources().contains(1)) {
                    wrapper1.gt((Object)"merchant_discount_price", (Object)0);
                }
                if (queryDTO.getDiscountSources().contains(2)) {
                    ((QueryWrapper)wrapper1.or()).gt((Object)"third_discount_price", (Object)0);
                }
                if (queryDTO.getDiscountSources().contains(3)) {
                    ((QueryWrapper)wrapper1.or()).gt((Object)"vip_discount_price", (Object)0);
                }
                if (queryDTO.getDiscountSources().contains(4)) {
                    ((QueryWrapper)wrapper1.or()).gt((Object)"toll_discount_price", (Object)0);
                }
            });
        }
        wrapper.like(StringUtils.isNotEmpty((CharSequence)queryDTO.getPlateNum()), (Object)"plate_num", (Object)queryDTO.getPlateNum());
        wrapper.ge(StringUtils.isNotBlank((CharSequence)queryDTO.getStartTime()), (Object)"pay_date", (Object)queryDTO.getStartTime());
        wrapper.le(StringUtils.isNotBlank((CharSequence)queryDTO.getEndTime()), (Object)"pay_date", (Object)queryDTO.getEndTime());
        wrapper.orderByDesc((Object)"id");
        Page pageList = this.page((Wrapper)wrapper, queryDTO.getPageNo(), queryDTO.getPageSize());
        wrapper.select(new String[]{"ifnull(sum(total_price), 0) sumTotalPrice, ifnull(sum(discount_price), 0) sumDiscountPrice, ifnull(sum(paid_price), 0) sumPaidPrice, ifnull(sum(merchant_discount_price), 0) sumMerchantDiscountPrice, ifnull(sum(third_discount_price), 0) sumThirdDiscountPrice, ifnull(sum(vip_discount_price), 0) sumVipDiscountPrice, ifnull(sum(toll_discount_price), 0) sumTollDiscountPrice"});
        Map sumPriceMap = this.getMap((Wrapper)wrapper);
        OrderPayDiscountPageVo voPage = new OrderPayDiscountPageVo();
        if (pageList == null || CollectionUtils.isEmpty((Collection)pageList.getRecords())) {
            voPage.setTotal(Long.valueOf(0L));
            voPage.setTotalPage(Integer.valueOf(0));
            return voPage;
        }
        voPage.setSumTotalPrice(Double.valueOf(((BigDecimal)sumPriceMap.get("sumTotalPrice")).doubleValue()));
        voPage.setSumDiscountPrice(Double.valueOf(((BigDecimal)sumPriceMap.get("sumDiscountPrice")).doubleValue()));
        voPage.setSumPaidPrice(Double.valueOf(((BigDecimal)sumPriceMap.get("sumPaidPrice")).doubleValue()));
        voPage.setSumMerchantDiscountPrice(Double.valueOf(((BigDecimal)sumPriceMap.get("sumMerchantDiscountPrice")).doubleValue()));
        voPage.setSumThirdDiscountPrice(Double.valueOf(((BigDecimal)sumPriceMap.get("sumThirdDiscountPrice")).doubleValue()));
        voPage.setSumVipDiscountPrice(Double.valueOf(((BigDecimal)sumPriceMap.get("sumVipDiscountPrice")).doubleValue()));
        voPage.setSumTollDiscountPrice(Double.valueOf(((BigDecimal)sumPriceMap.get("sumTollDiscountPrice")).doubleValue()));
        voPage.setTotalPage(Integer.valueOf((int)pageList.getPages()));
        List parkIdList = pageList.getRecords().stream().map(OrderPayDiscount::getParkId).distinct().collect(Collectors.toList());
        List parkList = this.parkService.findByParkIds(parkIdList);
        Map<Long, Park> parkMap = parkList.stream().collect(Collectors.toMap(BasePark::getId, park -> park));
        ArrayList<PayDiscountListVo> pageListVoList = new ArrayList<PayDiscountListVo>();
        for (OrderPayDiscount record : pageList.getRecords()) {
            PayDiscountListVo vo = new PayDiscountListVo();
            BeanUtils.copyProperties((Object)record, (Object)vo);
            Park park2 = parkMap.get(record.getParkId());
            if (park2 != null) {
                vo.setParkName(park2.getParkName());
            }
            vo.setParkTime(record.getParkTime());
            if (record.getParkTime() != null) {
                vo.setParkingTimeStr(DateTools.secondToSecondsTime((int)record.getParkTime().intValue()));
            }
            vo.setPayTime(record.getPayDate() != null ? Long.valueOf(record.getPayDate().getTime() / 1000L) : null);
            pageListVoList.add(vo);
        }
        voPage.setRows(pageListVoList);
        voPage.setTotal(Long.valueOf(pageList.getTotal()));
        return voPage;
    }

    @Override
    public OrderPayDiscount getOrderPayDiscountById(Long id) {
        return (OrderPayDiscount)this.getById(id);
    }

    @Override
    public Boolean addOrderPayDiscount(OrderPayDiscount entity) {
        return this.save(entity);
    }

    @Override
    public Boolean modifyOrderPayDiscount(OrderPayDiscount entity) {
        return this.updateById(entity);
    }

    @Override
    public Boolean removeOrderPayDiscountById(Long id) {
        return this.removeById(id);
    }
}

