/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.order.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.order.dao.OrderNotpaySubaccountMapper;
import com.icetech.order.domain.dto.NotPayAccountQueryDTO;
import com.icetech.order.domain.entity.OrderNotpaySubaccount;
import com.icetech.order.service.OrderNotpaySubaccountService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class OrderNotpaySubaccountServiceImpl
extends BaseServiceImpl<OrderNotpaySubaccountMapper, OrderNotpaySubaccount>
implements OrderNotpaySubaccountService {
    @Override
    public OrderNotpaySubaccount getOrderNotpaySubaccountById(Long id) {
        return (OrderNotpaySubaccount)this.getById(id);
    }

    @Override
    public Boolean addOrderNotpaySubaccount(OrderNotpaySubaccount entity) {
        return this.save(entity);
    }

    @Override
    public Boolean modifyOrderNotpaySubaccount(OrderNotpaySubaccount entity) {
        return this.updateById(entity);
    }

    @Override
    public Boolean removeOrderNotpaySubaccountById(Long id) {
        return this.removeById(id);
    }

    @Override
    public com.icetech.common.domain.Page<OrderNotpaySubaccount> getNotPaySubAccountPage(NotPayAccountQueryDTO queryDTO) {
        Page page = new Page();
        page.setCurrent((long)queryDTO.getPageNo().intValue());
        page.setSize((long)queryDTO.getPageSize().intValue());
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery(OrderNotpaySubaccount.class);
        List parkIds = queryDTO.getParkIds();
        if (CollectionUtils.isNotEmpty((Collection)parkIds) && !parkIds.contains(-1L)) {
            queryWrapper.in(OrderNotpaySubaccount::getParkId, (Collection)parkIds);
        }
        if (Objects.nonNull(queryDTO.getPayStartTime())) {
            queryWrapper.ge(OrderNotpaySubaccount::getPayTime, (Object)queryDTO.getPayStartTime());
        }
        if (Objects.nonNull(queryDTO.getPayEndTime())) {
            queryWrapper.le(OrderNotpaySubaccount::getPayTime, (Object)queryDTO.getPayEndTime());
        }
        queryWrapper.eq(OrderNotpaySubaccount::getDelFlag, (Object)0);
        queryWrapper.orderByDesc(OrderNotpaySubaccount::getPayTime);
        IPage result = this.page((IPage)page, (Wrapper)queryWrapper);
        return com.icetech.common.domain.Page.instance((int)Math.toIntExact(result.getPages()), (long)result.getTotal(), (List)result.getRecords());
    }

    @Override
    public OrderNotpaySubaccount totalMoney(NotPayAccountQueryDTO queryDTO) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery(OrderNotpaySubaccount.class);
        List parkIds = queryDTO.getParkIds();
        if (CollectionUtils.isNotEmpty((Collection)parkIds) && !parkIds.contains(-1L)) {
            queryWrapper.in(OrderNotpaySubaccount::getParkId, (Collection)parkIds);
        }
        if (Objects.nonNull(queryDTO.getPayStartTime())) {
            queryWrapper.ge(OrderNotpaySubaccount::getPayTime, (Object)queryDTO.getPayStartTime());
        }
        if (Objects.nonNull(queryDTO.getPayEndTime())) {
            queryWrapper.le(OrderNotpaySubaccount::getPayTime, (Object)queryDTO.getPayEndTime());
        }
        queryWrapper.eq(OrderNotpaySubaccount::getDelFlag, (Object)0);
        queryWrapper.select(new SFunction[]{OrderNotpaySubaccount::getPaidPrice, OrderNotpaySubaccount::getPlatformAmount});
        OrderNotpaySubaccount subAccount = new OrderNotpaySubaccount();
        List recordList = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)recordList)) {
            subAccount.setPaidPrice(recordList.stream().map(OrderNotpaySubaccount::getPaidPrice).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
            subAccount.setPlatformAmount(recordList.stream().map(OrderNotpaySubaccount::getPlatformAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        return subAccount;
    }
}

