/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.order.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.basics.constants.CommonConsts;
import com.icetech.basics.dao.park.ParkInoutdeviceDao;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.city.road.api.OrderApi;
import com.icetech.city.road.domain.constant.OrderRecoveryFlagConsts;
import com.icetech.city.road.domain.constant.OrderStatusConstant;
import com.icetech.city.road.domain.constant.OrderTypeConstant;
import com.icetech.city.road.domain.entity.request.param.OrderQueryParam;
import com.icetech.city.road.domain.table.Order;
import com.icetech.cloudcenter.api.order.OrderCarInfoService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.vo.NotPayDetailVo;
import com.icetech.common.domain.Page;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.dao.OrderNotpayDao;
import com.icetech.order.dao.OrderTagsDao;
import com.icetech.order.domain.dto.NotPayRecordQueryDTO;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderNotpay;
import com.icetech.order.domain.entity.OrderTags;
import com.icetech.order.domain.vo.CountVO;
import com.icetech.order.service.OrderNotpayService;
import com.icetech.third.service.third.MqPushService;
import com.icetech.third.utils.DateRangeUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderNotpayServiceImpl
extends BaseServiceImpl<OrderNotpayDao, OrderNotpay>
implements OrderNotpayService {
    private static final Logger log = LoggerFactory.getLogger(OrderNotpayServiceImpl.class);
    @Autowired
    private ParkService parkService;
    @Autowired
    private ParkInoutdeviceDao parkInoutdeviceDao;
    @Autowired
    private OrderTagsDao orderTagsDao;
    @Autowired
    private OrderCarInfoService orderCarInfoService;
    @Autowired
    private MqPushService mqPushService;
    @Autowired
    private OrderApi roadOrderApi;
    @Autowired
    private OrderInfoDao orderInfoDao;

    @Override
    public List<OrderNotpay> queryNotPayFee(Long parkId, String plateNum, Integer exType) {
        ObjectResponse objectResponse = this.parkService.getParkConfig(parkId);
        if (!ObjectResponse.isSuccess((Response)objectResponse)) {
            return null;
        }
        ParkConfig parkConfig = (ParkConfig)objectResponse.getData();
        return this.queryNotPayFee(parkId, plateNum, exType, parkConfig);
    }

    @Override
    public List<OrderNotpay> queryNotPayFee(Long parkId, String plateNum, Integer exType, ParkConfig parkConfig) {
        long endTime;
        if (!CommonConsts.YES.equals(parkConfig.getOnlyRecoverySelf())) {
            parkId = null;
        }
        if (exType == null) {
            exType = NumberUtils.toPrimitive((Integer)parkConfig.getEnterpayType()) == 1 && NumberUtils.toPrimitive((Integer)parkConfig.getExitpayType()) == 1 ? Integer.valueOf(2) : (NumberUtils.toPrimitive((Integer)parkConfig.getEnterpayType()) == 1 ? Integer.valueOf(1) : Integer.valueOf(2));
        }
        List list = null;
        if (exType == 1) {
            if (NumberUtils.toPrimitive((Integer)parkConfig.getEnterpayType()) == 1 && NumberUtils.toPrimitive((Integer)parkConfig.getEnterpayRangeDay()) > 0) {
                endTime = DateTools.unixTimestamp();
                long startTime = endTime - (long)(parkConfig.getEnterpayRangeDay() * 3600 * 24);
                LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderNotpay.class).eq(parkId != null, OrderNotpay::getParkId, (Object)parkId)).eq(OrderNotpay::getPlateNum, (Object)plateNum)).eq(OrderNotpay::getStatus, (Object)1)).orderByDesc(OrderNotpay::getId);
                list = this.list((Wrapper)queryWrapper);
            }
        } else if (NumberUtils.toPrimitive((Integer)parkConfig.getExitpayType()) == 1 && NumberUtils.toPrimitive((Integer)parkConfig.getExitpayRangeDay()) > 0) {
            endTime = DateTools.unixTimestamp();
            long startTime = endTime - (long)(parkConfig.getExitpayRangeDay() * 3600 * 24);
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderNotpay.class).eq(parkId != null, OrderNotpay::getParkId, (Object)parkId)).eq(OrderNotpay::getPlateNum, (Object)plateNum)).eq(OrderNotpay::getStatus, (Object)1)).orderByDesc(OrderNotpay::getId);
            list = this.list((Wrapper)queryWrapper);
        }
        if (CommonConsts.YES.equals(parkConfig.getAllowRecoveryRoad())) {
            List roadOrders = this.queryRoadUnpaidOrders(plateNum);
            if (list == null) {
                list = roadOrders;
            } else {
                list.addAll(roadOrders);
            }
        }
        return list;
    }

    @Override
    public OrderNotpay getOrderNotpayById(Long id) {
        return (OrderNotpay)this.getById(id);
    }

    @Override
    public Boolean addOrderNotpay(OrderNotpay entity) {
        this.orderTagsDao.insert(OrderTags.builder().parkId(entity.getParkId()).orderNum(entity.getOrderNum()).tagId(Integer.valueOf(OrderTags.TagIdEnum.NOT_PAY_CAR.getType())).build());
        boolean result = this.save(entity);
        this.mqPushService.pushOrderNotPay(entity);
        return result;
    }

    @Override
    public Boolean dealNotpayOrder(OrderNotpay orderNotpay) {
        this.orderTagsDao.delete((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderTags.class).eq(OrderTags::getOrderNum, (Object)orderNotpay.getOrderNum())).eq(OrderTags::getTagId, (Object)OrderTags.TagIdEnum.NOT_PAY_CAR.getType()));
        return this.update(orderNotpay, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(OrderNotpay.class).eq(OrderNotpay::getId, (Object)orderNotpay.getId())).eq(OrderNotpay::getParkId, (Object)orderNotpay.getParkId())).eq(OrderNotpay::getStatus, (Object)1));
    }

    @Override
    public OrderNotpay getOrderNotpayByOrderNum(String orderNum) {
        return (OrderNotpay)this.getOne((Wrapper)Wrappers.lambdaQuery(OrderNotpay.class).eq(OrderNotpay::getOrderNum, (Object)orderNum));
    }

    @Override
    public List<OrderNotpay> getListByOrderNums(List<String> orderNums) {
        return this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderNotpay.class).eq(OrderNotpay::getStatus, (Object)1)).in(OrderNotpay::getOrderNum, orderNums)).orderByDesc(OrderNotpay::getId));
    }

    @Override
    public List<OrderNotpay> getPaidPriceGroupParkId(Integer status, String month) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.select(new String[]{"park_id as parkId, sum(paid_price) as paidPrice"});
        wrapper.eq((Object)"status", (Object)status);
        wrapper.likeRight((Object)"oper_time", (Object)month);
        wrapper.groupBy((Object)"park_id");
        wrapper.orderByDesc((Object)"id");
        return this.list((Wrapper)wrapper);
    }

    @Override
    public Page<OrderNotpay> getNotPayRecord(NotPayRecordQueryDTO queryDTO, List<Long> parkIds) {
        QueryWrapper wrapper = new QueryWrapper();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(parkIds)) {
            wrapper.in(CollectionUtils.isNotEmpty(parkIds) && !parkIds.contains(-1L), (Object)"park_id", parkIds);
        }
        wrapper.eq(Objects.nonNull(queryDTO.getStatus()), (Object)"status", (Object)queryDTO.getStatus());
        wrapper.in(org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)queryDTO.getMendPayType()), (Object)"mend_pay_type", (Collection)queryDTO.getMendPayType());
        wrapper.eq(StringUtils.isNotEmpty((CharSequence)queryDTO.getPlateNum()), (Object)"plate_num", (Object)queryDTO.getPlateNum());
        if (Objects.nonNull(queryDTO.getStartDate()) && Objects.nonNull(queryDTO.getEndDate())) {
            wrapper.between((Object)(queryDTO.getStatus() == 1 ? "FROM_UNIXTIME(exit_time)" : "oper_time"), (Object)queryDTO.getStartDate(), (Object)queryDTO.getEndDate());
        }
        wrapper.orderByDesc((Object)"id");
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page = this.page((Wrapper)wrapper, queryDTO.getPageNo().intValue(), queryDTO.getPageSize().intValue());
        return Page.instance((int)Math.toIntExact(page.getPages()), (long)page.getTotal(), (List)page.getRecords());
    }

    @Override
    public CountVO getTotal(NotPayRecordQueryDTO queryDTO, List<Long> parkIds) {
        CountVO count = new CountVO();
        QueryWrapper wrapper = new QueryWrapper();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(parkIds)) {
            wrapper.in(CollectionUtils.isNotEmpty(parkIds) && !parkIds.contains(-1L), (Object)"park_id", parkIds);
        }
        wrapper.eq(Objects.nonNull(queryDTO.getStatus()), (Object)"status", (Object)queryDTO.getStatus());
        wrapper.in(org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)queryDTO.getMendPayType()), (Object)"mend_pay_type", (Collection)queryDTO.getMendPayType());
        wrapper.eq(StringUtils.isNotEmpty((CharSequence)queryDTO.getPlateNum()), (Object)"plate_num", (Object)queryDTO.getPlateNum());
        if (Objects.nonNull(queryDTO.getStartDate()) && Objects.nonNull(queryDTO.getEndDate())) {
            wrapper.between((Object)(queryDTO.getStatus() == 1 ? "FROM_UNIXTIME(exit_time)" : "oper_time"), (Object)queryDTO.getStartDate(), (Object)queryDTO.getEndDate());
        }
        wrapper.select(new String[]{"count(*) as 'totalNum', sum(total_price) as 'totalPrice', sum(paid_price) as 'paidPrice'"});
        List maps = this.listMaps((Wrapper)wrapper);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)maps)) {
            count = (CountVO)JSON.parseObject((String)JSON.toJSONString(maps.get(0)), CountVO.class);
        }
        return count;
    }

    @Override
    public Boolean deleteByOrderNum(String orderNum) {
        OrderNotpay orderNotpay = this.getOrderNotpayByOrderNum(orderNum);
        if (Objects.nonNull(orderNotpay)) {
            this.orderTagsDao.delete((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderTags.class).eq(OrderTags::getOrderNum, (Object)orderNum)).eq(OrderTags::getTagId, (Object)3));
            return this.removeById(orderNotpay.getId());
        }
        return Boolean.FALSE;
    }

    @Override
    public void updatePaidByOrderNums(List<NotPayDetailVo> vos, String channelCode, String operAccount) {
        log.info("[\u8865\u7f34\u8ba2\u5355\u66f4\u65b0] orderNums {}", vos);
        ParkInoutdevice parkInoutdevice = null;
        if (StringUtils.isNotEmpty((CharSequence)channelCode)) {
            parkInoutdevice = (ParkInoutdevice)this.parkInoutdeviceDao.selectLimitOne((LambdaQueryWrapper)Wrappers.lambdaQuery(ParkInoutdevice.class).eq(ParkInoutdevice::getInandoutCode, (Object)channelCode));
        }
        DateTime current = DateUtil.date();
        ParkInoutdevice finalParkInoutdevice = parkInoutdevice;
        for (NotPayDetailVo vo : vos) {
            if (!vo.isParkOrder()) continue;
            try {
                OrderCarInfo orderCarInfo;
                Object startDate;
                OrderNotpay orderNotpay = this.getOrderNotpayByOrderNum(vo.getOrderNum());
                if (!Objects.nonNull(orderNotpay)) continue;
                orderNotpay.setStatus(Integer.valueOf(2));
                orderNotpay.setPaidPrice(new BigDecimal(vo.getUnPayPrice()));
                if (finalParkInoutdevice != null) {
                    orderNotpay.setMendPayType(finalParkInoutdevice.getInandoutType());
                    orderNotpay.setChannelName(finalParkInoutdevice.getInandoutName());
                }
                orderNotpay.setOperTime((Date)current);
                this.updateById(orderNotpay);
                OrderInfo orderInfo = this.orderInfoDao.selectByOrderNum(orderNotpay.getOrderNum());
                boolean isHistoryTable = false;
                List yearQuarterRangeTableName = new ArrayList();
                if (orderInfo == null) {
                    startDate = DateUtil.offsetDay((Date)DateUtil.date(), (int)-90);
                    yearQuarterRangeTableName = DateRangeUtils.getYearQuarterRangeTableName((Date)startDate);
                    List<OrderInfo> orderInfos = this.orderInfoDao.selectWithHistoryByOrderNumList(yearQuarterRangeTableName, Collections.singletonList(orderNotpay.getOrderNum()));
                    if (orderInfos.size() == 0) {
                        log.error("[\u8865\u7f34\u8ba2\u5355\u66f4\u65b0] \u5931\u8d25, \u8ba2\u5355\u53f7\u4e0d\u5b58\u5728 {}", (Object)orderNotpay.getOrderNum());
                        continue;
                    }
                    orderInfo = orderInfos.get(0);
                    isHistoryTable = true;
                }
                orderInfo.setServiceStatus(Integer.valueOf(2));
                orderInfo.setOperAccount(operAccount);
                orderInfo.setPaidPrice(orderNotpay.getPaidPrice().setScale(2, 4).toString());
                orderInfo.setTotalPrice(orderNotpay.getTotalPrice().setScale(2, 4).toString());
                orderInfo.setDiscountPrice(orderNotpay.getDiscountPrice().setScale(2, 4).toString());
                if (!isHistoryTable) {
                    this.orderInfoDao.update(orderInfo, (Wrapper)Wrappers.lambdaUpdate(OrderInfo.class).eq(OrderInfo::getId, (Object)orderInfo.getId()));
                } else {
                    String tableName;
                    int n;
                    startDate = yearQuarterRangeTableName.iterator();
                    while (startDate.hasNext() && (n = this.orderInfoDao.updateHistoryTable(tableName = (String)startDate.next(), orderInfo)) <= 0) {
                    }
                }
                log.info("[\u8865\u7f34\u8ba2\u5355\u66f4\u65b0] orderNotpay {}, orderInfo {}", (Object)orderNotpay, (Object)orderInfo);
                if (StringUtils.isNotBlank((CharSequence)operAccount) && (orderCarInfo = this.orderCarInfoService.getByOrderNumWithHistory(orderNotpay.getOrderNum())) != null) {
                    orderCarInfo.setExitOperAccount(operAccount);
                    this.orderCarInfoService.updateByIdWithHistory(orderCarInfo);
                }
                this.orderTagsDao.delete((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderTags.class).eq(OrderTags::getOrderNum, (Object)orderNotpay.getOrderNum())).eq(OrderTags::getTagId, (Object)OrderTags.TagIdEnum.NOT_PAY_CAR.getType()));
                this.orderTagsDao.insert(OrderTags.builder().parkId(orderNotpay.getParkId()).orderNum(orderNotpay.getOrderNum()).tagId(Integer.valueOf(OrderTags.TagIdEnum.BACK_PAY.getType())).build());
            }
            catch (Exception e) {
                log.error("\u8865\u7f34\u8ba2\u5355\u66f4\u65b0\u5f02\u5e38, e=", (Throwable)e);
            }
        }
    }

    @Override
    public void largeOrder(OrderNotpay notPay) {
        ObjectResponse configResp = this.parkService.getParkConfig(notPay.getParkId());
        if (!ObjectResponse.isSuccess((Response)configResp)) {
            return;
        }
        ParkConfig config = (ParkConfig)configResp.getData();
        if (config.getIsOrderBigAmt() == 0) {
            return;
        }
        BigDecimal orderBigAmt = Optional.ofNullable(config.getOrderBigAmt()).orElse(BigDecimal.ZERO);
        if (notPay.getTotalPrice().compareTo(orderBigAmt) > 0) {
            notPay.setStatus(Integer.valueOf(4));
        } else {
            notPay.setStatus(Integer.valueOf(1));
        }
    }

    public List<OrderNotpay> queryRoadUnpaidOrders(String plateNum) {
        OrderQueryParam param = new OrderQueryParam();
        param.setPlateNum(plateNum);
        param.setOrderStatus(OrderStatusConstant.NORMAL);
        param.setOrderType(OrderTypeConstant.EXIT);
        param.setHasUnpaidPrice(Boolean.valueOf(true));
        param.setRecoveryFlag(OrderRecoveryFlagConsts.RECOVERY);
        List unpaidOrders = this.roadOrderApi.queryOrders(param);
        log.debug("\u8def\u5185\u6b20\u8d39\u8ba2\u5355\u67e5\u8be2|{}|{}", (Object)param, (Object)unpaidOrders);
        if (CollectionUtils.isEmpty((Collection)unpaidOrders)) {
            return Collections.emptyList();
        }
        ArrayList<OrderNotpay> orderNotpays = new ArrayList<OrderNotpay>(unpaidOrders.size());
        for (Order order : unpaidOrders) {
            OrderNotpay orderNotpay = new OrderNotpay();
            orderNotpay.setParkId(Long.valueOf(order.getParkId().longValue()));
            orderNotpay.setOrderNum(order.getOrderNum());
            orderNotpay.setPlateNum(order.getPlateNum());
            orderNotpay.setType(Integer.valueOf(1));
            orderNotpay.setEnterTime(order.getEnterTime());
            orderNotpay.setExitTime(order.getExitTime());
            orderNotpay.setCarType(order.getCarType());
            orderNotpay.setOrderSource(OrderNotpay.ORDER_SOURCE_ROAD.intValue());
            orderNotpay.setTotalPrice(order.getTotalPrice());
            orderNotpay.setDiscountPrice(order.getDiscountPrice());
            orderNotpay.setPaidPrice(order.getPaidPrice());
            orderNotpay.setStatus(Integer.valueOf(1));
            orderNotpays.add(orderNotpay);
        }
        return orderNotpays;
    }
}

