/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.order.service.impl;

import cn.hutool.core.date.BetweenFormatter;
import cn.hutool.core.date.DateUtil;
import com.google.common.collect.Maps;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.park.BasePark;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.service.park.impl.ParkServiceImpl;
import com.icetech.cloudcenter.api.order.OrderCarInfoService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.common.domain.Page;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.order.domain.dto.NotPayRecordQueryDTO;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderNotpay;
import com.icetech.order.domain.vo.CountVO;
import com.icetech.order.domain.vo.NotPayPage;
import com.icetech.order.domain.vo.OrderNotpayVO;
import com.icetech.order.service.OrderNotpayGroupService;
import com.icetech.order.service.OrderNotpayService;
import com.icetech.oss.OssService;
import com.icetech.park.domain.entity.park.Park;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderNotpayGroupServiceImpl
implements OrderNotpayGroupService {
    private static final Logger log = LoggerFactory.getLogger(OrderNotpayGroupServiceImpl.class);
    @Autowired
    private OrderNotpayService orderNotpayService;
    @Autowired
    private ParkServiceImpl parkService;
    @Autowired
    private OrderCarInfoService orderCarInfoService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private OssService ossService;
    @Autowired
    private ParkDeviceService parkDeviceService;

    @Override
    public Page<OrderNotpayVO> listPage(NotPayRecordQueryDTO notPayRecordQueryDTO, List<Long> parkIds) {
        Page<OrderNotpay> notPayRecord = this.orderNotpayService.getNotPayRecord(notPayRecordQueryDTO, parkIds);
        NotPayPage orderNotpayVoNotPayPage = new NotPayPage();
        BeanUtils.copyProperties(notPayRecord, (Object)orderNotpayVoNotPayPage);
        if (CollectionUtils.isNotEmpty((Collection)notPayRecord.getRows())) {
            Set parkIdSet = notPayRecord.getRows().stream().map(OrderNotpay::getParkId).collect(Collectors.toSet());
            Map parkMap = parkIdSet.parallelStream().map(t -> (Park)this.parkService.findByParkId(t).getData()).collect(Collectors.toMap(BasePark::getId, Function.identity(), (a, b) -> a));
            Set orderNums = notPayRecord.getRows().stream().map(OrderNotpay::getOrderNum).collect(Collectors.toSet());
            ObjectResponse carInfoList = this.orderCarInfoService.getCarInfoList(orderNums, null);
            Map orderCarInfoMap = ((List)carInfoList.getData()).stream().collect(Collectors.toMap(OrderCarInfo::getOrderNum, Function.identity()));
            List orderInfos = this.orderService.selectListByOrderNums(orderNums);
            Map orderInfoMap = orderInfos.stream().collect(Collectors.toMap(OrderInfo::getOrderNum, Function.identity()));
            Long[] channelIds = (Long[])notPayRecord.getRows().stream().map(OrderNotpay::getChannelId).distinct().toArray(Long[]::new);
            Map<Object, Object> parkInoutdeviceMap = Maps.newHashMap();
            List<Object> hasMorCameraChannelIds = new ArrayList();
            if (channelIds.length > 0) {
                List channelIdList;
                ObjectResponse devices;
                List data = (List)this.parkService.getChannelsByIds(channelIds).getData();
                if (CollectionUtils.isNotEmpty((Collection)data)) {
                    parkInoutdeviceMap = data.stream().collect(Collectors.toMap(ParkInoutdevice::getId, Function.identity()));
                }
                if (ObjectResponse.isSuccess((Response)(devices = this.parkDeviceService.getDeviceListByChannelIds(channelIdList = notPayRecord.getRows().stream().filter(op -> op.getEvidenceVideo() == null).map(OrderNotpay::getChannelId).distinct().collect(Collectors.toList()), Integer.valueOf(9)))) && CollectionUtils.isNotEmpty((Collection)((Collection)devices.getData()))) {
                    hasMorCameraChannelIds = ((List)devices.getData()).stream().map(ParkDevice::getChannelId).collect(Collectors.toList());
                }
            }
            HashMap finalParkInoutdeviceMap = parkInoutdeviceMap;
            ArrayList finalHasMorCameraChannelIds = hasMorCameraChannelIds;
            List orderNotpayVOS = notPayRecord.getRows().stream().map(t -> {
                ParkInoutdevice parkInoutdevice;
                OrderInfo orderInfo;
                OrderCarInfo orderCarInfo;
                OrderNotpayVO orderNotpayVo = new OrderNotpayVO();
                BeanUtils.copyProperties((Object)t, (Object)orderNotpayVo);
                orderNotpayVo.setEvidenceVideo("");
                if (MapUtils.isNotEmpty((Map)parkMap) && parkMap.containsKey(t.getParkId())) {
                    orderNotpayVo.setParkName(((Park)parkMap.get(t.getParkId())).getParkName());
                    orderNotpayVo.setParkCode(((Park)parkMap.get(t.getParkId())).getParkCode());
                    orderNotpayVo.setIsInterior(((Park)parkMap.get(t.getParkId())).getIsInterior());
                }
                if (Objects.nonNull(orderCarInfo = (OrderCarInfo)orderCarInfoMap.get(t.getOrderNum()))) {
                    Boolean loadImage = notPayRecordQueryDTO.getLoadImage();
                    if (loadImage.booleanValue()) {
                        orderNotpayVo.setEnterImg(this.ossService.getImageUrl(orderCarInfo.getSmallEnterImage()));
                        orderNotpayVo.setExitImg(this.ossService.getImageUrl(orderCarInfo.getSmallExitImage()));
                    } else {
                        orderNotpayVo.setEnterImg("");
                        orderNotpayVo.setExitImg("");
                    }
                }
                if (Objects.nonNull(orderInfo = (OrderInfo)orderInfoMap.get(t.getOrderNum()))) {
                    orderNotpayVo.setOrderId(orderInfo.getId());
                    orderNotpayVo.setHasSon(orderInfo.getHasSon());
                }
                if (Objects.nonNull(orderNotpayVo.getEnterTime()) && Objects.nonNull(orderNotpayVo.getExitTime())) {
                    Long exitTime = orderNotpayVo.getExitTime();
                    long bet = Math.max(exitTime - orderNotpayVo.getEnterTime(), 0L) * 1000L;
                    orderNotpayVo.setParkingTimeStr(DateUtil.formatBetween((long)bet, (BetweenFormatter.Level)BetweenFormatter.Level.SECOND));
                }
                if (Objects.nonNull(parkInoutdevice = (ParkInoutdevice)finalParkInoutdeviceMap.get(t.getChannelId()))) {
                    orderNotpayVo.setWarnChannelName(parkInoutdevice.getInandoutName());
                }
                if (StringUtils.isNotBlank((CharSequence)t.getEvidenceVideo()) || parkInoutdevice != null && finalHasMorCameraChannelIds.contains(parkInoutdevice.getId().intValue())) {
                    orderNotpayVo.setHasMorCamera(Integer.valueOf(1));
                } else {
                    orderNotpayVo.setHasMorCamera(Integer.valueOf(0));
                }
                return orderNotpayVo;
            }).collect(Collectors.toList());
            orderNotpayVoNotPayPage.setRows(orderNotpayVOS);
        }
        return orderNotpayVoNotPayPage;
    }

    @Override
    public CountVO count(NotPayRecordQueryDTO notPayRecordQueryDTO, List<Long> parkIds) {
        return this.orderNotpayService.getTotal(notPayRecordQueryDTO, parkIds);
    }

    @Override
    public OrderNotpayVO detail(Long recordId, Long parkId) {
        OrderNotpay orderNotpay = (OrderNotpay)this.orderNotpayService.getById(recordId);
        if (orderNotpay == null) {
            return null;
        }
        if (!Objects.equals(orderNotpay.getParkId(), parkId)) {
            return null;
        }
        OrderNotpayVO orderNotpayVo = new OrderNotpayVO();
        BeanUtils.copyProperties((Object)orderNotpay, (Object)orderNotpayVo);
        orderNotpayVo.setEvidenceVideo(this.ossService.getImageUrl(orderNotpayVo.getEvidenceVideo()));
        Park park = (Park)this.parkService.findByParkId(parkId).getData();
        OrderCarInfo orderCarInfo = (OrderCarInfo)this.orderCarInfoService.getCarInfo(orderNotpay.getOrderNum(), parkId).getData();
        OrderInfo orderInfo = (OrderInfo)this.orderService.findByOrderNum(orderNotpay.getOrderNum()).getData();
        if (Objects.nonNull(park)) {
            orderNotpayVo.setParkName(park.getParkName());
            orderNotpayVo.setParkCode(park.getParkCode());
            orderNotpayVo.setIsInterior(park.getIsInterior());
        }
        if (Objects.nonNull(orderCarInfo)) {
            orderNotpayVo.setEnterImg(this.ossService.getImageUrl(orderCarInfo.getSmallEnterImage()));
            orderNotpayVo.setExitImg(this.ossService.getImageUrl(orderCarInfo.getSmallExitImage()));
        }
        if (Objects.nonNull(orderInfo)) {
            orderNotpayVo.setOrderId(orderInfo.getId());
            orderNotpayVo.setHasSon(orderInfo.getHasSon());
            orderNotpayVo.setOrderId(orderInfo.getId());
            Long exitTime = DateUtil.currentSeconds();
            if (Objects.nonNull(orderInfo.getExitTime())) {
                exitTime = orderInfo.getExitTime();
            }
            if (NumberUtils.toPrimitive((Integer)orderInfo.getNoneEnterFlag()) == 0) {
                long bet = Math.max(exitTime - orderInfo.getEnterTime(), 0L) * 1000L;
                orderNotpayVo.setParkingTimeStr(DateUtil.formatBetween((long)bet, (BetweenFormatter.Level)BetweenFormatter.Level.SECOND));
            }
        }
        return orderNotpayVo;
    }
}

