/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.order.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.google.common.collect.Lists;
import com.icetech.basics.dao.park.ParkConfigDao;
import com.icetech.cloudcenter.api.order.OrderMoneyService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.order.SumOrderMoneyDto;
import com.icetech.cloudcenter.domain.response.WorkRecordDto;
import com.icetech.cloudcenter.domain.response.WorkReportDto;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.order.dao.OrderMoneyDao;
import com.icetech.order.dao.OrderPayDao;
import com.icetech.order.dao.ReportBclientDao;
import com.icetech.order.domain.entity.OrderMoney;
import com.icetech.order.domain.entity.ReportBclient;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.user.dao.SaasUserDao;
import com.icetech.user.dao.SaasUserParkMapper;
import com.icetech.user.dao.WorkReportDao;
import com.icetech.user.domain.entity.user.SaasUser;
import com.icetech.user.domain.entity.user.WorkReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="orderMoneyService")
public class OrderMoneyServiceImpl
implements OrderMoneyService {
    private static final Logger log = LoggerFactory.getLogger(OrderMoneyServiceImpl.class);
    @Autowired
    private SaasUserDao saasUserDao;
    @Autowired
    private SaasUserParkMapper saasUserParkMapper;
    @Autowired
    private ParkService parkService;
    @Autowired
    private WorkReportDao workReportDao;
    @Autowired
    private OrderPayDao orderPayDao;
    @Autowired
    private ReportBclientDao reportBclientDao;
    @Autowired
    private OrderMoneyDao orderMoneyDao;
    @Autowired
    private ParkConfigDao parkConfigDao;

    public ObjectResponse addWorkReports(Integer userId) {
        try {
            List parkIds = this.saasUserParkMapper.selectParkIdsByUserId(userId);
            if (!CollectionUtils.isEmpty((Collection)parkIds)) {
                ArrayList workReports = Lists.newArrayList();
                List unReportParkIds = this.workReportDao.selectUnReport(parkIds, userId);
                if (CollectionUtils.isEmpty((Collection)unReportParkIds)) {
                    unReportParkIds = Lists.newArrayList();
                }
                for (Long parkId : parkIds) {
                    if (unReportParkIds.contains(parkId)) continue;
                    WorkReport newWorkReport = new WorkReport();
                    newWorkReport.setParkId(Integer.valueOf(Math.toIntExact(parkId)));
                    newWorkReport.setUserId(userId);
                    newWorkReport.setWorkOnTime(new Date());
                    newWorkReport.setIsReport(Boolean.FALSE);
                    newWorkReport.setCreateTime(new Date());
                    workReports.add(newWorkReport);
                }
                if (!CollectionUtils.isEmpty((Collection)workReports)) {
                    this.workReportDao.batchInsert((List)workReports);
                }
            }
        }
        catch (Exception e) {
            log.error("[\u6dfb\u52a0\u7ed3\u8d26\u8bb0\u5f55\u5931\u8d25]|e=", (Throwable)e);
        }
        return ObjectResponse.success();
    }

    @DSTransactional
    public ObjectResponse<WorkRecordDto> getParkReportMoney(Integer userId, String parkCode) {
        if (StringUtils.isBlankOrNullChar((CharSequence)parkCode)) {
            return ObjectResponse.failed((String)"400", (String)"\u8f66\u573a\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        Park park = (Park)this.parkService.findByParkCode(parkCode).getData();
        if (park == null) {
            return ObjectResponse.failed((String)"400", (String)"\u8f66\u573a\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        SaasUser saasUser = this.saasUserDao.load(userId.intValue());
        WorkReport workReport = this.workReportDao.selectByWorkOn(userId, Integer.valueOf(Math.toIntExact(park.getId())));
        if (Objects.nonNull(workReport)) {
            String endTime = DateTools.getFormat((Date)new Date());
            SumOrderMoneyDto sumOrderMoneyDto = this.orderPayDao.selectMoneyCountByTime(workReport.getWorkOnTime(), workReport.getId(), Math.toIntExact(park.getId()), endTime);
            WorkRecordDto workRecordDto = new WorkRecordDto();
            workRecordDto.setUserName(saasUser.getUsername());
            workRecordDto.setWorkOnTime(workReport.getWorkOnTime());
            workRecordDto.setReportPrice(sumOrderMoneyDto.getPaidPrice());
            workRecordDto.setDiscountPrice(sumOrderMoneyDto.getDiscountPrice());
            workRecordDto.setTotalPrice(sumOrderMoneyDto.getTotalPrice());
            workRecordDto.setPayNum(sumOrderMoneyDto.getCountNUm().intValue());
            workRecordDto.setEndTime(endTime);
            workRecordDto.setUnits(this.parkConfigDao.selectByParkId(park.getId().longValue()).getMoneyunitType());
            return ObjectResponse.success((Object)workRecordDto);
        }
        WorkRecordDto workRecordDto = new WorkRecordDto();
        workRecordDto.setUserName(saasUser.getUsername());
        return ObjectResponse.success((Object)workRecordDto);
    }

    @DSTransactional
    public ObjectResponse settleAccounts(Integer userId, String parkCode, String endTime, Integer from) {
        Park park = (Park)this.parkService.findByParkCode(parkCode).getData();
        if (park == null) {
            return ObjectResponse.failed((String)"400");
        }
        SaasUser saasUser = this.saasUserDao.load(userId.intValue());
        WorkReport workReport = this.workReportDao.selectByWorkOn(userId, Integer.valueOf(Math.toIntExact(park.getId())));
        if (Objects.nonNull(workReport)) {
            SumOrderMoneyDto sumOrderMoneyDto = this.orderPayDao.selectMoneyCountByTime(workReport.getWorkOnTime(), workReport.getId(), Math.toIntExact(park.getId()), endTime);
            workReport.setIsReport(Boolean.TRUE);
            workReport.setWorkOffTime(new Date());
            workReport.setReportPrice(sumOrderMoneyDto.getPaidPrice());
            workReport.setUpdateTime(new Date());
            this.workReportDao.updateByPrimaryKeySelective(workReport);
            log.info("[\u73b0\u91d1\u7ed3\u8d26\u63a5\u53e3]\u66f4\u65b0\u5b8c\u6210. info[{}]", (Object)JsonUtils.toString((Object)workReport));
            ReportBclient reportBclient = new ReportBclient();
            reportBclient.setParkId(park.getId());
            reportBclient.setName(saasUser.getName());
            reportBclient.setType(from);
            reportBclient.setCharge(sumOrderMoneyDto.getTotalPrice());
            reportBclient.setRealcharge(sumOrderMoneyDto.getPaidPrice());
            reportBclient.setDisamount(sumOrderMoneyDto.getDiscountPrice());
            reportBclient.setUsername(saasUser.getUsername());
            reportBclient.setStartTime(workReport.getWorkOnTime());
            reportBclient.setEndTime(workReport.getWorkOffTime());
            reportBclient.setPayNum(sumOrderMoneyDto.getCountNUm());
            reportBclient.setAmount(sumOrderMoneyDto.getPaidPrice());
            this.reportBclientDao.insert(reportBclient);
            return ObjectResponse.success();
        }
        return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_404.getCode(), (String)"\u7ed3\u8d26\u5931\u8d25");
    }

    public ObjectResponse<WorkReportDto> getWorkReport(Integer userId, Long parkId) {
        WorkReport workReport = this.workReportDao.selectByWorkOn(userId, Integer.valueOf(Math.toIntExact(parkId)));
        if (workReport != null) {
            WorkReportDto workReportDto = new WorkReportDto();
            BeanUtils.copyProperties((Object)workReport, (Object)workReportDto);
            return ObjectResponse.success((Object)workReportDto);
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse addOrderMoney(Integer reportId, Long orderPayId) {
        OrderMoney orderMoney = new OrderMoney();
        orderMoney.setOrderPayId(Integer.valueOf(orderPayId.intValue()));
        orderMoney.setReportId(reportId);
        this.orderMoneyDao.insert(orderMoney);
        return ObjectResponse.success();
    }
}

