/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.order.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageHelper;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.cloudcenter.api.order.OrderDiscountService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.order.query.OrderDiscountQuery;
import com.icetech.cloudcenter.domain.request.DiscountRequest;
import com.icetech.cloudcenter.domain.request.QueryDiscountRequest;
import com.icetech.common.constants.DataCollectionEnum;
import com.icetech.common.domain.Page;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.PageQuery;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.NumberUtils;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.order.dao.OrderDiscountDao;
import com.icetech.order.domain.dto.DiscountDto;
import com.icetech.order.domain.entity.OrderDiscount;
import com.icetech.third.anno.DS_SLAVE;
import com.icetech.third.dao.send.SendinfoDao;
import com.icetech.third.domain.entity.third.SendInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="orderDiscountService")
public class OrderDiscountServiceImpl
extends BaseServiceImpl<OrderDiscountDao, OrderDiscount>
implements OrderDiscountService {
    private static final Logger log = LoggerFactory.getLogger(OrderDiscountServiceImpl.class);
    @Autowired
    private OrderDiscountDao orderDiscountDao;
    @Autowired
    private SendinfoDao sendinfoDao;
    @Autowired
    private ParkService parkService;

    public ObjectResponse modifyDiscount(DiscountRequest discountRequest) {
        OrderDiscountQuery orderDiscountQuery = new OrderDiscountQuery();
        BeanUtils.copyProperties((Object)discountRequest, (Object)orderDiscountQuery);
        this.orderDiscountDao.updateStatus(orderDiscountQuery);
        log.info("[\u8ba2\u5355\u4f18\u60e0\u670d\u52a1] \u4fee\u6539\u4f18\u60e0\u72b6\u6001\u5b8c\u6210\uff0corderNum\uff1a{}", (Object)discountRequest.getOrderNum());
        return ObjectResponse.success();
    }

    public ObjectResponse<Map<String, String>> findDiscountNos(String tradeNo, Long parkId) {
        OrderDiscount orderDiscount = new OrderDiscount();
        orderDiscount.setTradeNo(tradeNo);
        orderDiscount.setParkId(parkId);
        List<OrderDiscount> orderDiscounts = this._findList(orderDiscount);
        if (orderDiscounts.size() > 0) {
            String discountNos = StrUtil.join((CharSequence)",", (Iterable)orderDiscounts.stream().map(OrderDiscount::getDiscountNo).collect(Collectors.toList()));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("discountNos", discountNos);
            return ObjectResponse.success(map);
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<OrderDiscount> findOne(OrderDiscount orderDiscount) {
        if (orderDiscount.getId() == null) {
            orderDiscount.setDelFlag(Integer.valueOf(0));
        }
        return ObjectResponse.returnNotFoundIfNull((Object)this.orderDiscountDao.selectLimitOne(orderDiscount));
    }

    public ObjectResponse<Long> addDiscount(OrderDiscount orderDiscount) {
        orderDiscount.setCarStatus(Integer.valueOf(1));
        int n = this.orderDiscountDao.insert(orderDiscount);
        if (n == 0) {
            return ObjectResponse.failed((String)"402");
        }
        return ObjectResponse.success((Object)orderDiscount.getId());
    }

    @Transactional(rollbackFor={Exception.class})
    public ObjectResponse<Boolean> addDiscounts(List<OrderDiscount> orderDiscounts) {
        int count = this.orderDiscountDao.saveBatch(orderDiscounts);
        if (count > 0) {
            return ObjectResponse.success((Object)Boolean.TRUE);
        }
        return ObjectResponse.success((Object)Boolean.FALSE);
    }

    public ObjectResponse<List<OrderDiscount>> findList(OrderDiscount orderDiscount) {
        PageQuery pageQuery = new PageQuery();
        pageQuery.setParam((Object)orderDiscount);
        List<OrderDiscount> orderDiscounts = this.orderDiscountDao.selectListByPage((PageQuery<OrderDiscount>)pageQuery);
        return ObjectResponse.success(orderDiscounts);
    }

    public ObjectResponse<Double> getSumDiscount(Long parkId, String orderNum, Integer from, Integer status) {
        Double sumDiscount = this.orderDiscountDao.sumDiscount(orderNum, parkId, from, status);
        return ObjectResponse.success((Object)sumDiscount);
    }

    public ObjectResponse updateDiscount(OrderDiscount orderDiscount) {
        int n = this.orderDiscountDao.updateById(orderDiscount);
        if (n == 0) {
            return ObjectResponse.failed((String)"402");
        }
        return ObjectResponse.success();
    }

    public ObjectResponse<OrderDiscount> findOneByPlateNum(Long parkId, String plateNum) {
        OrderDiscount orderDiscount = new OrderDiscount();
        orderDiscount.setParkId(parkId);
        orderDiscount.setPlateNum(plateNum);
        orderDiscount.setDelFlag(Integer.valueOf(0));
        OrderDiscount orderDiscount1 = (OrderDiscount)this.orderDiscountDao.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery((Object)orderDiscount).orderByDesc(OrderDiscount::getId)).last("limit 1"));
        return ObjectResponse.returnNotFoundIfNull((Object)orderDiscount1);
    }

    @DS_SLAVE
    public ObjectResponse<Page<OrderDiscount>> getOrderDiscountList(Long parkId, QueryDiscountRequest request) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page orderDiscountPage = this.orderDiscountDao.selectPage((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderDiscount.class).eq(OrderDiscount::getParkId, (Object)parkId)).eq(StringUtils.isNotEmpty((CharSequence)request.getOrderNum()), OrderDiscount::getOrderNum, (Object)request.getOrderNum())).eq(StringUtils.isNotEmpty((CharSequence)request.getTradeNo()), OrderDiscount::getTradeNo, (Object)request.getTradeNo())).eq(StringUtils.isNotEmpty((CharSequence)request.getDiscountNo()), OrderDiscount::getDiscountNo, (Object)request.getDiscountNo())).eq(OrderDiscount::getDelFlag, (Object)0)).gt(OrderDiscount::getSendTime, (Object)request.getStartTime())).lt(OrderDiscount::getSendTime, (Object)request.getEndTime())).orderByDesc(OrderDiscount::getSendTime), request.getPageNo().intValue(), request.getPageSize().intValue());
        return ObjectResponse.success((Object)Page.instance((int)Math.toIntExact(orderDiscountPage.getPages()), (long)orderDiscountPage.getTotal(), (List)orderDiscountPage.getRecords()));
    }

    public ObjectResponse<Integer> countNumByOrderNum(String orderNum, Long parkId) {
        Integer count = this.orderDiscountDao.selectCount((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderDiscount.class).eq(OrderDiscount::getOrderNum, (Object)orderNum)).eq(OrderDiscount::getDelFlag, (Object)0)).eq(OrderDiscount::getParkId, (Object)parkId));
        return ObjectResponse.success((Object)count);
    }

    @Transactional
    public ObjectResponse<Integer> cancelDiscount(Long id, Long parkId) {
        OrderDiscount orderDiscount = new OrderDiscount();
        orderDiscount.setId(id);
        orderDiscount.setDelFlag(Integer.valueOf(1));
        int i = this.orderDiscountDao.updateById(orderDiscount);
        if (i > 0) {
            ObjectResponse objectResponse = this.parkService.getParkConfig(parkId);
            ObjectResponse.notError((Response)objectResponse);
            Integer dataCollection = ((ParkConfig)objectResponse.getData()).getDataCollection();
            if (DataCollectionEnum.\u7aef\u7f51\u4e91.getType().equals(dataCollection)) {
                this.sendinfoDao.insert((Object)new SendInfo(parkId, id, DownServiceEnum.\u64a4\u9500\u4f18\u60e0\u4e0b\u53d1.getServiceType()));
            }
        }
        return ObjectResponse.success((Object)i);
    }

    public List<OrderDiscount> findDiscountByOrderNum(List<String> orderNums, Integer status) {
        return this.orderDiscountDao.selectDiscountByOrderNum(orderNums, status);
    }

    public List<DiscountDto> findList(DiscountDto dto) {
        PageHelper.startPage((int)NumberUtils.toPrimitive((Integer)dto.getPageNo(), (int)1), (int)NumberUtils.toPrimitive((Integer)dto.getPageSize(), (int)10));
        return this.orderDiscountDao.selectListDiy(dto);
    }

    public DiscountDto findOne(Long id) {
        if (id == null) {
            return null;
        }
        DiscountDto dto = new DiscountDto();
        dto.setId(id);
        List<DiscountDto> discountDtos = this.orderDiscountDao.selectListDiy(dto);
        if (CollectionUtils.isEmpty(discountDtos)) {
            return null;
        }
        return discountDtos.get(0);
    }

    public String findMerchantName(Long parkId, String discountNo, String orderNum) {
        return this.orderDiscountDao.selectMerchantName(parkId, discountNo, orderNum);
    }

    public List<OrderDiscount> _findList(OrderDiscount orderDiscount) {
        PageQuery pageQuery = new PageQuery();
        pageQuery.setParam((Object)orderDiscount);
        return this.orderDiscountDao.selectListByPage((PageQuery<OrderDiscount>)pageQuery);
    }
}

