/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.order.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.csp.sentinel.annotation.SentinelResource;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.common.collect.Lists;
import com.icetech.basics.dao.park.ParkDao;
import com.icetech.basics.domain.entity.park.BasePark;
import com.icetech.basics.sentinel.ExceptionUtils;
import com.icetech.cloudcenter.api.order.OrderCarInfoService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.order.query.OrderEnexCount;
import com.icetech.cloudcenter.domain.request.FlowRequest;
import com.icetech.cloudcenter.domain.request.OrderEnexQueryRequest;
import com.icetech.cloudcenter.domain.response.EnexCountDto;
import com.icetech.cloudcenter.domain.response.EnexDetailDto;
import com.icetech.cloudcenter.domain.response.EnterMatchDto;
import com.icetech.cloudcenter.domain.response.ParkEnterOrexitCountDto;
import com.icetech.cloudcenter.domain.response.ParkEnterOrexitNumDto;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.order.dao.OrderCarInfoDao;
import com.icetech.order.dao.OrderEnexCountDao;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.dao.OrderSonCarInfoDao;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderSonCarInfo;
import com.icetech.oss.OssService;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.redis.handle.RedisHandle;
import com.icetech.third.anno.DS_SLAVE;
import com.icetech.third.utils.DateRangeUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="orderCarInfoService")
public class OrderCarInfoServiceImpl
extends BaseServiceImpl<OrderCarInfoDao, OrderCarInfo>
implements OrderCarInfoService {
    private static final Logger log = LoggerFactory.getLogger(OrderCarInfoServiceImpl.class);
    @Resource
    private OrderCarInfoDao orderCarInfoDao;
    @Resource
    private OrderEnexCountDao orderEnexCountDao;
    @Resource
    private ParkDao parkDao;
    @Resource
    private ParkService parkService;
    @Resource
    private OssService ossService;
    @Resource
    private OrderInfoDao orderInfoDao;
    @Resource
    private OrderSonCarInfoDao orderSonCarInfoDao;
    @Resource
    private RedisHandle redisHandle;

    @DS_SLAVE
    @SentinelResource(value="OrderEnexService.enexCount", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<EnexCountDto> enexCount(FlowRequest flowRequest) {
        EnexCountDto enexCountDto = new EnexCountDto();
        long enterCount = this.orderInfoDao.enterCount(flowRequest);
        long exitCount = this.orderInfoDao.exitCount(flowRequest);
        enexCountDto.setTotalEnter(Long.valueOf(enterCount));
        enexCountDto.setTotalExit(Long.valueOf(exitCount));
        return ObjectResponse.success((Object)enexCountDto);
    }

    @DS_SLAVE
    @SentinelResource(value="OrderEnexService.enexDetail", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<List<EnexDetailDto>> enexDetail(FlowRequest flowRequest) {
        String parkIdList = flowRequest.getParkIdList();
        List<EnexDetailDto> enterDetails = this.orderInfoDao.enterDetail(flowRequest);
        List<EnexDetailDto> exitDetails = this.orderInfoDao.exitDetail(flowRequest);
        exitDetails.addAll(enterDetails);
        exitDetails.sort(Comparator.comparingLong(detail -> detail.getExitTime() == null ? detail.getEnterTime() : detail.getExitTime()).reversed());
        List<EnexDetailDto> enexDetailDtos = exitDetails.subList(0, Integer.min(exitDetails.size(), 30));
        if (CollUtil.isNotEmpty(enexDetailDtos)) {
            List parks = this.parkDao.selectByIds(parkIdList);
            Map<Long, String> parkMap = parks.stream().collect(Collectors.toMap(BasePark::getId, BasePark::getParkName));
            for (EnexDetailDto dto : enexDetailDtos) {
                int serviceStatus = dto.getServiceStatus();
                if (serviceStatus == 1) {
                    dto.setStatus("\u5165\u573a");
                    dto.setGateName(dto.getEnterNo());
                    dto.setActionTime(DateTools.getFormat((long)(dto.getEnterTime() * 1000L)));
                } else if (serviceStatus == 2 || serviceStatus == 4) {
                    dto.setStatus("\u51fa\u573a");
                    dto.setGateName(dto.getExitNo());
                    if (dto.getExitTime() != null) {
                        dto.setActionTime(DateTools.getFormat((long)(dto.getExitTime() * 1000L)));
                    } else {
                        dto.setActionTime(DateTools.getFormat((long)(dto.getEnterTime() * 1000L)));
                    }
                }
                dto.setParkName(parkMap.get(dto.getParkId()));
            }
        }
        return ObjectResponse.success(enexDetailDtos);
    }

    @DS_SLAVE
    @SentinelResource(value="OrderEnexService.countDaysEnterOrExitNum", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<List<ParkEnterOrexitCountDto>> countDaysEnterOrExitNum(String parkIdList, Integer day, String monthCount) {
        return ObjectResponse.success(this.countEnterOrExitNum(parkIdList, day, monthCount));
    }

    @DS_SLAVE
    @SentinelResource(value="OrderEnexService.countDaysEnterOrExitNum2", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<List<ParkEnterOrexitCountDto>> countDaysEnterOrExitNum(String parkIdList, Integer day) {
        return ObjectResponse.success(this.countEnterOrExitNum(parkIdList, day, null));
    }

    @Transactional(rollbackFor={Exception.class})
    public ObjectResponse countHoursEnterOrExitNum(String time) {
        long toTime;
        long fromTime;
        log.info("[\u7edf\u8ba1\u5f53\u524d\u65f6\u95f4\u7684\u8fdb\u51fa\u573a\u6d41\u91cf],{}", (Object)time);
        if (StringUtils.isNotBlank((CharSequence)time)) {
            fromTime = DateRangeUtils.getTimeHourTime((String)time);
            toTime = DateRangeUtils.getNextTimeHourTime((Long)fromTime, (Integer)1);
            log.info("[\u7edf\u8ba1\u5f53\u524d\u65f6\u95f4\u7684\u8fdb\u51fa\u573a\u6d41\u91cf],\u5f00\u59cb\u65f6\u95f4:{},\u7ed3\u675f\u65f6\u95f4:{}", (Object)fromTime, (Object)toTime);
        } else {
            toTime = DateRangeUtils.getNowHourTime();
            fromTime = DateRangeUtils.getNextTimeHourTime((Long)toTime, (Integer)-1);
            log.info("[\u7edf\u8ba1\u5f53\u524d\u65f6\u95f4\u7684\u8fdb\u51fa\u573a\u6d41\u91cf],\u5f00\u59cb\u65f6\u95f4:{},\u7ed3\u675f\u65f6\u95f4:{}", (Object)fromTime, (Object)toTime);
        }
        List<ParkEnterOrexitNumDto> parkEnterNumDtos = this.orderInfoDao.countHoursEnterNum(fromTime, toTime - 1L);
        List<ParkEnterOrexitNumDto> parkExitNumDtos = this.orderInfoDao.countHoursExitNum(fromTime, toTime - 1L);
        if (CollectionUtils.isEmpty(parkEnterNumDtos) && CollectionUtils.isEmpty(parkExitNumDtos)) {
            return ObjectResponse.success(null);
        }
        if (!CollectionUtils.isEmpty(parkEnterNumDtos)) {
            parkEnterNumDtos.forEach(parkEnterOrexitNumDto -> {
                Date current = new Date(fromTime * 1000L);
                OrderEnexCount orderEnexCount = new OrderEnexCount();
                orderEnexCount.setParkId(parkEnterOrexitNumDto.getParkId().longValue());
                orderEnexCount.setTotalEnter(parkEnterOrexitNumDto.getTotalEnter().intValue());
                orderEnexCount.setTotalExit(0);
                orderEnexCount.setCountTime(current);
                OrderEnexCount count = this.orderEnexCountDao.selectByCountTime(parkEnterOrexitNumDto.getParkId(), current);
                if (Objects.isNull(count)) {
                    this.orderEnexCountDao.insert(orderEnexCount);
                } else {
                    count.setTotalEnter(parkEnterOrexitNumDto.getTotalEnter().intValue());
                    this.orderEnexCountDao.update(count);
                }
            });
        }
        if (!CollectionUtils.isEmpty(parkExitNumDtos)) {
            parkExitNumDtos.forEach(orexitNumDto -> {
                Date current = new Date(fromTime * 1000L);
                OrderEnexCount orderEnexCount = new OrderEnexCount();
                orderEnexCount.setParkId(orexitNumDto.getParkId().longValue());
                orderEnexCount.setTotalEnter(0);
                orderEnexCount.setTotalExit(orexitNumDto.getTotalExit().intValue());
                orderEnexCount.setCountTime(current);
                OrderEnexCount count = this.orderEnexCountDao.selectByCountTime(orexitNumDto.getParkId(), current);
                if (Objects.isNull(count)) {
                    this.orderEnexCountDao.insert(orderEnexCount);
                } else {
                    count.setTotalExit(orexitNumDto.getTotalExit().intValue());
                    this.orderEnexCountDao.update(count);
                }
            });
        }
        return ObjectResponse.success(null);
    }

    @DS_SLAVE
    @SentinelResource(value="OrderEnexService.getEnterMatchList", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<List<EnterMatchDto>> getEnterMatchList(OrderEnexQueryRequest orderEnexQueryRequest) {
        String parkCode = orderEnexQueryRequest.getParkCode();
        Date startTime = orderEnexQueryRequest.getStartTime();
        Date endTime = orderEnexQueryRequest.getEndTime();
        Boolean isNoPlate = orderEnexQueryRequest.getIsNoPlate();
        String plateNum = orderEnexQueryRequest.getPlateNum();
        Park park = (Park)this.parkService.findByParkCode(parkCode).getData();
        if (park == null) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        ArrayList<String> plateNums = new ArrayList();
        if (plateNum != null && plateNum.length() >= 7) {
            plateNums = this.getPlateNums(plateNum);
            plateNum = null;
        }
        List<EnterMatchDto> enterMatchDtos = this.orderInfoDao.selectEnterMatchListNew(park.getId(), Objects.isNull(startTime) ? null : Long.valueOf(startTime.getTime() / 1000L), Objects.isNull(endTime) ? null : Long.valueOf(endTime.getTime() / 1000L), plateNum, isNoPlate, plateNums);
        enterMatchDtos.removeIf(Objects::isNull);
        if (CollectionUtils.isEmpty(enterMatchDtos)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        Map<String, EnterMatchDto> collect = enterMatchDtos.stream().collect(Collectors.groupingBy(EnterMatchDto::getPlateNumber, Collectors.collectingAndThen(Collectors.toList(), value -> (EnterMatchDto)value.get(0))));
        enterMatchDtos = new ArrayList<EnterMatchDto>(collect.values());
        enterMatchDtos.sort(Comparator.comparing(EnterMatchDto::getEnterTimeLong).reversed());
        int pageNo = NumberUtils.toPrimitive((Integer)orderEnexQueryRequest.getPageNo(), (int)1);
        int pageSize = NumberUtils.toPrimitive((Integer)orderEnexQueryRequest.getPageSize(), (int)10);
        int s = (pageNo - 1) * pageSize;
        int e = Math.min((pageNo - 1) * pageSize + pageSize, enterMatchDtos.size());
        if (s > enterMatchDtos.size()) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        List<EnterMatchDto> dataList = enterMatchDtos.subList(s, e);
        if (CollectionUtils.isEmpty(dataList)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        List orderNums = dataList.stream().map(EnterMatchDto::getOrderNum).collect(Collectors.toList());
        List carInfos = this.orderCarInfoDao.selectList((Wrapper)Wrappers.lambdaQuery(OrderCarInfo.class).select(new SFunction[]{OrderCarInfo::getOrderNum, OrderCarInfo::getEnterImage}).in(OrderCarInfo::getOrderNum, orderNums));
        if (CollectionUtils.isEmpty((Collection)carInfos)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        Map<String, String> enterImageMap = carInfos.stream().collect(Collectors.toMap(OrderCarInfo::getOrderNum, carInfo -> carInfo.getEnterImage() == null ? "" : carInfo.getEnterImage()));
        dataList.forEach(enterMatchDto -> {
            String imageUrl = (String)enterImageMap.get(enterMatchDto.getOrderNum());
            if (StringUtils.isNotBlank((CharSequence)imageUrl)) {
                enterMatchDto.setImgUrl(this.ossService.getImageUrl(imageUrl));
            }
            if (enterMatchDto.getEnterTimeLong() != null) {
                enterMatchDto.setParkTime(DateTools.secondToSecondsTime((int)Math.toIntExact(System.currentTimeMillis() / 1000L - enterMatchDto.getEnterTimeLong())));
            }
        });
        return ObjectResponse.success(dataList);
    }

    public List<String> getPlateNums(String plateNum) {
        ArrayList<String> lists = new ArrayList<String>();
        String str = StringUtils.substring((String)plateNum, (int)2, (int)7);
        lists.add(StringUtils.substring((String)str, (int)0, (int)3));
        lists.add(StringUtils.substring((String)str, (int)1, (int)4));
        lists.add(StringUtils.substring((String)str, (int)2, (int)5));
        return lists;
    }

    public ObjectResponse<OrderCarInfo> getCarInfo(String orderNum, Long parkId) {
        OrderInfo orderInfo = new OrderInfo();
        orderInfo.setParkId(parkId);
        orderInfo.setOrderNum(orderNum);
        orderInfo = this.orderInfoDao.selectLimitOneOrderByEnterDesc(orderInfo);
        if (orderInfo == null) {
            return ObjectResponse.failed((String)"404");
        }
        OrderCarInfo carInfo = this.orderCarInfoDao.selectByOrderNum(orderNum);
        if (carInfo == null) {
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.success((Object)carInfo);
    }

    public ObjectResponse<String> addCarInfo(OrderCarInfo carInfo) {
        if (StringUtils.isBlank((CharSequence)carInfo.getOrderNum())) {
            carInfo.setOrderNum(CodeTools.GenerateOrderNum());
        }
        this.orderCarInfoDao.insert(carInfo);
        return ObjectResponse.success((Object)carInfo.getOrderNum());
    }

    public ObjectResponse<Integer> updateCarInfo(OrderCarInfo carInfo) {
        int lines = this.orderCarInfoDao.updateByOrderNum(carInfo);
        if (lines > 0) {
            return ObjectResponse.success((Object)lines);
        }
        return ObjectResponse.failed((String)"404");
    }

    @DS_SLAVE
    public ObjectResponse<List<OrderCarInfo>> getCarInfoList(Collection<String> orderNums, Long parkId) {
        List orderCarInfos = this.orderCarInfoDao.selectList((Wrapper)Wrappers.lambdaQuery(OrderCarInfo.class).in(OrderCarInfo::getOrderNum, orderNums));
        return ObjectResponse.success((Object)orderCarInfos);
    }

    public ObjectResponse<OrderSonCarInfo> getOrderSonCarInfo(Long orderSonId) {
        OrderSonCarInfo orderSonCarInfo = this.orderSonCarInfoDao.selectByOrderSonId(orderSonId);
        return ObjectResponse.returnNotFoundIfNull((Object)orderSonCarInfo);
    }

    public OrderCarInfo getByOrderNumWithHistory(String orderNum) {
        OrderCarInfo orderCarInfo = this.orderCarInfoDao.selectByOrderNum(orderNum);
        if (orderCarInfo != null) {
            return orderCarInfo;
        }
        DateTime startDate = DateUtil.offsetDay((Date)DateUtil.date(), (int)-90);
        List yearQuarterRangeTableName = DateRangeUtils.getYearQuarterRangeTableName((Date)startDate);
        return this.orderCarInfoDao.selectByOrderNumListWithHistory(orderNum, yearQuarterRangeTableName);
    }

    public OrderCarInfo getByOrderNum(String orderNum) {
        return this.orderCarInfoDao.selectByOrderNum(orderNum);
    }

    public int updateByIdWithHistory(OrderCarInfo updateCarInfo) {
        int i;
        block1: {
            String table;
            i = this.orderCarInfoDao.updateById(updateCarInfo);
            if (i != 0) break block1;
            DateTime startDate = DateUtil.offsetDay((Date)DateUtil.date(), (int)-90);
            List yearQuarterRangeTableName = DateRangeUtils.getYearQuarterRangeTableName((Date)startDate);
            Iterator iterator = yearQuarterRangeTableName.iterator();
            while (iterator.hasNext() && (i = this.orderCarInfoDao.updateByIdWithHistory(updateCarInfo, table = (String)iterator.next())) <= 0) {
            }
        }
        return i;
    }

    private List<ParkEnterOrexitCountDto> countEnterOrExitNum(String parkIdList, Integer day, String monthCount) {
        String finalToTime;
        String finalFromTime;
        String cacheKey;
        List parkEnterOrexitCountDtos;
        ArrayList resluts = Lists.newArrayList();
        if (day <= 3 && day != 0) {
            Long fromTime = DateRangeUtils.get24HourTime();
            List hours = DateRangeUtils.get24Hours();
            long toTime = DateRangeUtils.getNowHourTime();
            if (day == 2) {
                fromTime = DateRangeUtils.getYesterdayHourTime((int)(24 + DateRangeUtils.getHour((Date)new Date())));
                toTime = DateRangeUtils.getYesterdayHourTime((int)DateRangeUtils.getHour((Date)new Date())) - 1L;
                hours = DateRangeUtils.get24DayHours();
            }
            if (day == 3) {
                fromTime = DateRangeUtils.getNHourTime((Integer)DateRangeUtils.getHour((Date)new Date()));
                toTime = DateRangeUtils.getNowHourTime();
                hours = DateRangeUtils.getNowHours();
            }
            String cacheKey2 = "countHoursEnterOrExitNum:" + parkIdList + "_" + fromTime + "_" + toTime;
            String finalFromTime2 = DateTools.getFormat((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date(fromTime * 1000L));
            String finalToTime2 = DateTools.getFormat((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date(toTime * 1000L));
            List parkEnterOrexitCountDtos2 = this.redisHandle.cacheList(cacheKey2, ParkEnterOrexitCountDto.class, () -> this.orderEnexCountDao.countHoursEnterOrExitNum(parkIdList, finalFromTime2, finalToTime2), 3600000L);
            hours.forEach(s -> {
                ParkEnterOrexitCountDto ret = new ParkEnterOrexitCountDto();
                ret.setTimeRange(s + ":00-" + (s + 1) + ":00");
                if (CollectionUtils.isEmpty((Collection)parkEnterOrexitCountDtos2)) {
                    ret.setTotalEnter(Integer.valueOf(0));
                    ret.setTotalExit(Integer.valueOf(0));
                } else {
                    ParkEnterOrexitCountDto res = parkEnterOrexitCountDtos2.stream().filter(enex -> Integer.valueOf(enex.getTimeRange()).equals(s)).findFirst().orElse(null);
                    if (Objects.nonNull(res)) {
                        ret.setTotalExit(res.getTotalExit());
                        ret.setTotalEnter(res.getTotalEnter());
                    } else {
                        ret.setTotalExit(Integer.valueOf(0));
                        ret.setTotalEnter(Integer.valueOf(0));
                    }
                }
                resluts.add(ret);
            });
            return resluts;
        }
        Long fromTime = DateRangeUtils.getDayTime((Integer)day);
        long toTime = DateRangeUtils.getTodayTime();
        List days = DateRangeUtils.getDays((Integer)day);
        if (StringUtils.isNotEmpty((CharSequence)monthCount)) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                fromTime = sdf.parse(monthCount + "-01 00:00:00").getTime() / 1000L;
                SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                toTime = sdf2.parse(monthCount + "-" + DateRangeUtils.getDaysOfMonth((Date)sdf.parse(monthCount + "-01")) + " 23:59:59").getTime() / 1000L;
                days = DateRangeUtils.getMonthDays((String)monthCount);
            }
            catch (Exception e) {
                log.error("[\u7edf\u8ba1\u51fa\u5165\u53e3\u6d41\u91cf]\u5904\u7406\u5931\u8d25: {}. parkIdList[{}], day[{}], monthCount[{}]", new Object[]{e.getMessage(), parkIdList, day, monthCount, e});
            }
        }
        if ((parkEnterOrexitCountDtos = this.redisHandle.cacheList(cacheKey = "countDaysEnterOrExitNum:" + parkIdList + "_" + fromTime + "_" + toTime, ParkEnterOrexitCountDto.class, () -> this.lambda$countEnterOrExitNum$9(parkIdList, finalFromTime = DateTools.getFormat((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date(fromTime * 1000L)), finalToTime = DateTools.getFormat((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date(toTime * 1000L))), 3600000L)).size() > 0) {
            days.forEach(s -> {
                ParkEnterOrexitCountDto ret = new ParkEnterOrexitCountDto();
                ret.setTimeRange(s);
                if (CollectionUtils.isEmpty((Collection)parkEnterOrexitCountDtos)) {
                    ret.setTotalEnter(Integer.valueOf(0));
                    ret.setTotalExit(Integer.valueOf(0));
                } else {
                    ParkEnterOrexitCountDto res = parkEnterOrexitCountDtos.stream().filter(enex -> enex.getTimeRange().equals(s)).findFirst().orElse(null);
                    if (Objects.nonNull(res)) {
                        ret.setTotalExit(res.getTotalExit());
                        ret.setTotalEnter(res.getTotalEnter());
                    } else {
                        ret.setTotalExit(Integer.valueOf(0));
                        ret.setTotalEnter(Integer.valueOf(0));
                    }
                }
                resluts.add(ret);
            });
        }
        return resluts;
    }

    private /* synthetic */ List lambda$countEnterOrExitNum$9(String parkIdList, String finalFromTime, String finalToTime) {
        return this.orderEnexCountDao.countDaysEnterOrExitNum(parkIdList, finalFromTime, finalToTime);
    }
}

