/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.order.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.icetech.common.utils.NumberUtils;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.order.dao.OrderBackMapper;
import com.icetech.order.domain.dto.OrderBackQueryDTO;
import com.icetech.order.domain.entity.OrderBack;
import com.icetech.order.service.OrderBackService;
import com.icetech.third.service.third.MqPushService;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderBackServiceImpl
extends BaseServiceImpl<OrderBackMapper, OrderBack>
implements OrderBackService {
    @Autowired
    private MqPushService mqPushService;

    @Override
    public OrderBack getOrderBackById(Long id) {
        return (OrderBack)this.getById(id);
    }

    @Override
    public Boolean addOrderBack(OrderBack entity) {
        boolean result = this.save(entity);
        this.mqPushService.pushOrderBack(entity);
        return result;
    }

    @Override
    public Boolean modifyOrderBack(OrderBack entity) {
        return this.updateById(entity);
    }

    @Override
    public Boolean removeOrderBackById(Long id) {
        return this.removeById(id);
    }

    @Override
    public com.icetech.common.domain.Page<OrderBack> getPageList(OrderBackQueryDTO queryDTO, List<Long> parkIds) {
        QueryWrapper wrapper = new QueryWrapper();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(parkIds)) {
            wrapper.in(CollectionUtils.isNotEmpty(parkIds) && !parkIds.contains(-1L), (Object)"park_id", parkIds);
        }
        wrapper.like(StringUtils.isNotEmpty((CharSequence)queryDTO.getPlateNum()), (Object)"plate_num", (Object)queryDTO.getPlateNum());
        wrapper.eq((Object)"inandout_type", (Object)queryDTO.getInandoutType());
        if (NumberUtils.toPrimitive((Integer)queryDTO.getInandoutType(), (int)2) == 1) {
            wrapper.eq((Object)"review_status", (Object)0);
        }
        wrapper.between(Objects.nonNull(queryDTO.getStartDate()) && Objects.nonNull(queryDTO.getEndDate()), (Object)"create_time", (Object)queryDTO.getStartDate(), (Object)queryDTO.getEndDate());
        wrapper.orderByDesc((Object)"id");
        Page page = this.page((Wrapper)wrapper, queryDTO.getPageNo().intValue(), queryDTO.getPageSize().intValue());
        return com.icetech.common.domain.Page.instance((int)Math.toIntExact(page.getPages()), (long)page.getTotal(), (List)page.getRecords());
    }

    @Override
    public Integer getTotal(OrderBackQueryDTO queryDTO, List<Long> parkIds) {
        QueryWrapper wrapper = new QueryWrapper();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(parkIds)) {
            wrapper.in(CollectionUtils.isNotEmpty(parkIds) && !parkIds.contains(-1L), (Object)"park_id", parkIds);
        }
        wrapper.like(StringUtils.isNotEmpty((CharSequence)queryDTO.getPlateNum()), (Object)"plate_num", (Object)queryDTO.getPlateNum());
        wrapper.eq((Object)"inandout_type", (Object)queryDTO.getInandoutType());
        if (NumberUtils.toPrimitive((Integer)queryDTO.getInandoutType(), (int)2) == 1) {
            wrapper.eq((Object)"review_status", (Object)0);
        }
        wrapper.between(Objects.nonNull(queryDTO.getStartDate()) && Objects.nonNull(queryDTO.getEndDate()), (Object)"create_time", (Object)queryDTO.getStartDate(), (Object)queryDTO.getEndDate());
        return this.count((Wrapper)wrapper);
    }

    @Override
    public List<OrderBack> getListByOrderNum(String orderNum) {
        return this.list((Wrapper)Wrappers.lambdaQuery(OrderBack.class).eq(OrderBack::getOrderNum, (Object)orderNum));
    }
}

