/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.order.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.BetweenFormatter;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.park.BasePark;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.service.park.impl.ParkInoutdeviceServiceImpl;
import com.icetech.basics.service.park.impl.ParkServiceImpl;
import com.icetech.cloudcenter.api.order.OrderCarInfoService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.common.domain.Page;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.order.domain.dto.OrderBackQueryDTO;
import com.icetech.order.domain.entity.OrderBack;
import com.icetech.order.domain.entity.OrderBackReview;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.order.domain.vo.CountVO;
import com.icetech.order.domain.vo.OrderBackVO;
import com.icetech.order.service.OrderBackGroupService;
import com.icetech.order.service.OrderBackService;
import com.icetech.order.service.impl.OrderSonInfoServiceImpl;
import com.icetech.oss.OssService;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.freespace.UpdateParkFreeSpaceServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderBackGroupServiceImpl
implements OrderBackGroupService {
    private static final Logger log = LoggerFactory.getLogger(OrderBackGroupServiceImpl.class);
    @Resource
    private OrderBackService orderBackService;
    @Resource
    private ParkServiceImpl parkService;
    @Autowired
    private OrderCarInfoService orderCarInfoService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private OssService ossService;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private ParkInoutdeviceServiceImpl parkInoutdeviceService;
    @Autowired
    private OrderSonInfoServiceImpl orderSonInfoService;
    @Autowired
    private UpdateParkFreeSpaceServiceImpl updateParkFreeSpaceService;

    @Override
    public Page<OrderBackVO> listPage(OrderBackQueryDTO queryDTO, List<Long> parkIds) {
        Set channelIds;
        ObjectResponse response;
        Page<OrderBack> pageList = this.orderBackService.getPageList(queryDTO, parkIds);
        Page backVoPage = new Page();
        BeanUtil.copyProperties(pageList, (Object)backVoPage, (String[])new String[0]);
        if (Objects.isNull(pageList) || CollectionUtils.isEmpty((Collection)pageList.getRows())) {
            return backVoPage;
        }
        Map<Object, Object> parkDeviceMap = new HashMap(16);
        if (queryDTO.getInandoutType() == 1 && ObjectResponse.isSuccess((Response)(response = this.parkDeviceService.getDeviceListByChannelIds(new ArrayList(channelIds = pageList.getRows().stream().map(OrderBack::getChannelId).collect(Collectors.toSet())), Integer.valueOf(9))))) {
            parkDeviceMap = ((List)response.getData()).stream().collect(Collectors.toMap(ParkDevice::getChannelId, parkDevice -> parkDevice));
        }
        HashMap finalParkDeviceMap = parkDeviceMap;
        Set parkIdSet = pageList.getRows().stream().map(OrderBack::getParkId).collect(Collectors.toSet());
        Map parkMap = this.parkService.listByIds(parkIdSet).stream().collect(Collectors.toMap(BasePark::getId, Function.identity()));
        Set orderNums = pageList.getRows().stream().map(OrderBack::getOrderNum).collect(Collectors.toSet());
        Map orderCarInfoMap = ((List)this.orderCarInfoService.getCarInfoList(orderNums, null).getData()).stream().collect(Collectors.toMap(OrderCarInfo::getOrderNum, Function.identity()));
        Map orderInfoMap = this.orderService.selectListByOrderNums(orderNums).stream().collect(Collectors.toMap(OrderInfo::getOrderNum, Function.identity()));
        List orderBacks = pageList.getRows().stream().map(t -> {
            OrderInfo orderInfo;
            OrderCarInfo orderCarInfo;
            OrderBackVO vo = new OrderBackVO();
            BeanUtil.copyProperties((Object)t, (Object)vo, (String[])new String[0]);
            if (StringUtils.isNotEmpty((CharSequence)t.getEvidenceVideo()) || Objects.nonNull(finalParkDeviceMap.get(Math.toIntExact(t.getChannelId())))) {
                vo.setHasMorCamera(Integer.valueOf(1));
            }
            vo.setEvidenceVideo("");
            BasePark basePark = (BasePark)parkMap.get(t.getParkId());
            if (basePark != null) {
                vo.setParkCode(basePark.getParkCode());
                vo.setParkName(basePark.getParkName());
                vo.setIsInterior(basePark.getIsInterior());
            }
            if ((orderCarInfo = (OrderCarInfo)orderCarInfoMap.get(t.getOrderNum())) != null) {
                vo.setEnterNo(orderCarInfo.getEnterNo());
                vo.setExitNo(orderCarInfo.getExitNo());
                if (queryDTO.getLoadImage().booleanValue()) {
                    vo.setEnterImg(this.ossService.getImageUrl(orderCarInfo.getSmallEnterImage()));
                    vo.setExitImg(this.ossService.getImageUrl(orderCarInfo.getSmallExitImage()));
                } else {
                    vo.setEnterImg("");
                    vo.setExitImg("");
                }
            }
            if ((orderInfo = (OrderInfo)orderInfoMap.get(t.getOrderNum())) != null) {
                vo.setServiceStatus(orderInfo.getServiceStatus());
                vo.setHasSon(orderInfo.getHasSon());
                vo.setOrderId(orderInfo.getId());
                long exitTime = Optional.ofNullable(orderInfo.getExitTime()).orElse(DateUtil.currentSeconds());
                long duration = Math.max(exitTime - orderInfo.getEnterTime(), 0L) * 1000L;
                vo.setParkingTimeStr(DateUtil.formatBetween((long)duration, (BetweenFormatter.Level)BetweenFormatter.Level.SECOND));
            }
            return vo;
        }).collect(Collectors.toList());
        backVoPage.setRows(orderBacks);
        return backVoPage;
    }

    @Override
    public CountVO count(OrderBackQueryDTO queryDTO, List<Long> parkIds) {
        Integer total = this.orderBackService.getTotal(queryDTO, parkIds);
        return CountVO.builder().totalNum(total).build();
    }

    @Override
    public OrderBackVO detail(Long recordId, Long parkId) {
        OrderInfo orderInfo;
        OrderCarInfo orderCarInfo;
        OrderBack orderBack = this.orderBackService.getOrderBackById(recordId);
        if (orderBack == null) {
            return null;
        }
        if (!Objects.equals(orderBack.getParkId(), parkId)) {
            return null;
        }
        OrderBackVO vo = new OrderBackVO();
        BeanUtil.copyProperties((Object)orderBack, (Object)vo, (String[])new String[0]);
        vo.setEvidenceVideo(this.ossService.getImageUrl(vo.getEvidenceVideo()));
        Park basePark = (Park)this.parkService.findByParkId(parkId).getData();
        if (Objects.nonNull(basePark)) {
            vo.setParkCode(basePark.getParkCode());
            vo.setParkName(basePark.getParkName());
            vo.setIsInterior(basePark.getIsInterior());
        }
        if (Objects.nonNull(orderCarInfo = (OrderCarInfo)this.orderCarInfoService.getCarInfo(orderBack.getOrderNum(), parkId).getData())) {
            vo.setEnterImg(this.ossService.getImageUrl(orderCarInfo.getSmallEnterImage()));
            vo.setExitImg(this.ossService.getImageUrl(orderCarInfo.getSmallExitImage()));
            vo.setEnterNo(orderCarInfo.getEnterNo());
            vo.setExitNo(orderCarInfo.getExitNo());
        }
        if (Objects.nonNull(orderInfo = (OrderInfo)this.orderService.findByOrderNum(orderBack.getOrderNum()).getData())) {
            vo.setServiceStatus(orderInfo.getServiceStatus());
            vo.setHasSon(orderInfo.getHasSon());
            vo.setOrderId(orderInfo.getId());
            Long exitTime = DateUtil.currentSeconds();
            if (Objects.nonNull(orderInfo.getExitTime())) {
                exitTime = orderInfo.getExitTime();
            }
            long bet = Math.max(exitTime - orderInfo.getEnterTime(), 0L) * 1000L;
            vo.setParkingTimeStr(DateUtil.formatBetween((long)bet, (BetweenFormatter.Level)BetweenFormatter.Level.SECOND));
        }
        return vo;
    }

    @Override
    public OrderBackVO detail(String orderNum, Long parkId) {
        List<OrderBack> listByOrderNum = this.orderBackService.getListByOrderNum(orderNum);
        if (CollectionUtils.isNotEmpty(listByOrderNum)) {
            OrderBack orderBack = (OrderBack)CollectionUtil.getLast(listByOrderNum);
            return this.detail(orderBack.getId(), parkId);
        }
        return null;
    }

    @Override
    public List<OrderBackVO> listByOrderNum(String orderNum) {
        List<OrderBack> orderBacks = this.orderBackService.getListByOrderNum(orderNum);
        ArrayList vos = Lists.newArrayList();
        orderBacks.forEach(o -> {
            OrderInfo orderInfo;
            OrderCarInfo orderCarInfo;
            OrderBackVO vo = new OrderBackVO();
            BeanUtil.copyProperties((Object)o, (Object)vo, (String[])new String[0]);
            vo.setEvidenceVideo(this.ossService.getImageUrl(vo.getEvidenceVideo()));
            Park basePark = (Park)this.parkService.findByParkId(o.getParkId()).getData();
            if (Objects.nonNull(basePark)) {
                vo.setParkCode(basePark.getParkCode());
                vo.setParkName(basePark.getParkName());
                vo.setIsInterior(basePark.getIsInterior());
            }
            if (Objects.nonNull(orderCarInfo = (OrderCarInfo)this.orderCarInfoService.getCarInfo(o.getOrderNum(), o.getParkId()).getData())) {
                vo.setEnterImg(this.ossService.getImageUrl(orderCarInfo.getEnterImage()));
                vo.setExitImg(this.ossService.getImageUrl(orderCarInfo.getExitImage()));
                vo.setEnterNo(orderCarInfo.getEnterNo());
                vo.setExitNo(orderCarInfo.getExitNo());
            }
            if (Objects.nonNull(orderInfo = (OrderInfo)this.orderService.findByOrderNum(o.getOrderNum()).getData())) {
                vo.setOrderId(orderInfo.getId());
                vo.setServiceStatus(orderInfo.getServiceStatus());
            }
            vos.add(vo);
        });
        return vos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ObjectResponse<Void> review(OrderBackReview review) {
        OrderBack orderBack = (OrderBack)this.orderBackService.getById(review.getId());
        if (Objects.isNull(orderBack)) {
            return ObjectResponse.failed((String)"500", (String)"\u5ba1\u6838\u5931\u8d25\uff0c\u6682\u65e0\u6b64ID");
        }
        if (orderBack.getReviewStatus() == 1) {
            return ObjectResponse.failed((String)"500", (String)"\u5ba1\u6838\u5931\u8d25\uff0c\u6b64\u5355\u5df2\u5ba1\u6838");
        }
        orderBack.setReviewStatus(Integer.valueOf(1));
        this.orderBackService.modifyOrderBack(orderBack);
        if (review.getReviewType() == 1) {
            return ObjectResponse.success();
        }
        ParkInoutdevice inoutDevice = (ParkInoutdevice)this.parkInoutdeviceService.getOne((Wrapper)Wrappers.lambdaQuery(ParkInoutdevice.class).eq(ParkInoutdevice::getId, (Object)orderBack.getChannelId()));
        if (Objects.isNull(inoutDevice)) {
            return ObjectResponse.failed((String)"500", (String)"\u5ba1\u6838\u5931\u8d25\uff0c\u6682\u65e0\u6b64\u901a\u9053");
        }
        ObjectResponse orderInfoResponse = this.orderService.findByOrderNum(orderBack.getOrderNum());
        if (!ObjectResponse.isSuccess((Response)orderInfoResponse)) {
            return ObjectResponse.failed((String)"500", (String)"\u5ba1\u6838\u5931\u8d25\uff0c\u6682\u65e0\u6b64\u8ba2\u5355");
        }
        OrderInfo orderInfo = (OrderInfo)orderInfoResponse.getData();
        orderInfo.setServiceStatus(Integer.valueOf(3));
        this.orderService.updateOrderInfo(orderInfo);
        if (Integer.valueOf(1).equals(orderInfo.getHasSon())) {
            this.orderSonInfoService.updateServiceStatusByOrderNums(Collections.singletonList(orderInfo.getOrderNum()), 3);
        }
        if (inoutDevice.getIsMaster() == 0) {
            List<OrderSonInfo> sonInfos = this.orderSonInfoService.getInfosByOrderNum(orderBack.getParkId(), orderBack.getOrderNum());
            sonInfos.forEach(sonInfo -> {
                sonInfo.setServiceStatus(Integer.valueOf(4));
                this.orderSonInfoService.save(sonInfo);
            });
        }
        this.updateParkFreeSpaceService.resetFreeSpace(orderBack.getParkId());
        return ObjectResponse.success();
    }
}

