/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.order.service.impl;

import com.alibaba.csp.sentinel.annotation.SentinelResource;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import com.icetech.basics.dao.park.ParkDao;
import com.icetech.basics.dao.park.ParkInoutdeviceDao;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.sentinel.ExceptionUtils;
import com.icetech.cloudcenter.api.order.OrderAuthService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.request.OrderAuthQueryRequest;
import com.icetech.cloudcenter.domain.response.OrderAuthDto;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.DateTools;
import com.icetech.order.dao.OrderAuthDao;
import com.icetech.order.dao.OrderCarInfoDao;
import com.icetech.order.domain.entity.OrderAuthInfo;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.oss.OssService;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.third.anno.DS_SLAVE;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderAuthServiceImpl
implements OrderAuthService {
    private static final Logger log = LoggerFactory.getLogger(OrderAuthServiceImpl.class);
    @Autowired
    private ParkDao parkDao;
    @Autowired
    private ParkInoutdeviceDao parkInoutdeviceDao;
    @Autowired
    private OrderAuthDao orderAuthDao;
    @Resource
    private OrderCarInfoDao orderCarInfoDao;
    @Autowired
    private ParkService parkService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private OssService ossService;

    public ObjectResponse upOrderAuth(OrderAuthInfo orderAuthInfo) {
        OrderAuthInfo orderAuthInfo1 = this.orderAuthDao.selectByAuthNum(orderAuthInfo.getAuthNum());
        if (orderAuthInfo1 != null) {
            if (StringUtils.isNotEmpty((CharSequence)orderAuthInfo.getOperAccount())) {
                String operAccount = orderAuthInfo1.getOperAccount();
                operAccount = operAccount + " | " + orderAuthInfo.getOperAccount();
                orderAuthInfo1.setOperAccount(operAccount);
            }
            orderAuthInfo1.setRemark(orderAuthInfo.getRemark());
            orderAuthInfo1.setUpPrice(orderAuthInfo.getUpPrice());
            orderAuthInfo1.setStatus(orderAuthInfo.getStatus());
            orderAuthInfo1.setAuthStatus(orderAuthInfo.getAuthStatus());
            orderAuthInfo1.setUpdateTime(new Date());
            this.orderAuthDao.updateOrderAuth(orderAuthInfo1);
        }
        return ObjectResponse.success();
    }

    public ObjectResponse addOrderAuth(OrderAuthInfo orderAuthInfo) {
        String authNum = "A" + System.currentTimeMillis();
        orderAuthInfo.setAuthNum(authNum);
        this.orderAuthDao.insert(orderAuthInfo);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("authNum", authNum);
        return ObjectResponse.success(map);
    }

    @DS_SLAVE
    @SentinelResource(value="OrderAuthService.selectOrderByAuthNum", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<OrderAuthDto> selectOrderByAuthNum(String authNum) {
        ObjectResponse byOrderNum;
        ParkInoutdevice parkInoutdevice;
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        OrderAuthInfo orderAuthInfo = this.orderAuthDao.selectByAuthNum(authNum);
        OrderAuthDto orderAuthDto = new OrderAuthDto();
        orderAuthDto.setId(orderAuthInfo.getId());
        orderAuthDto.setRemark(orderAuthInfo.getRemark());
        orderAuthDto.setAuthNum(orderAuthInfo.getAuthNum());
        if (orderAuthInfo.getCreateTime() != null) {
            orderAuthDto.setApplyTime(sf.format(orderAuthInfo.getCreateTime()));
        }
        if (orderAuthInfo.getUpdateTime() != null) {
            orderAuthDto.setAnswerTime(sf.format(orderAuthInfo.getUpdateTime()));
        }
        orderAuthDto.setTotalPrice(orderAuthInfo.getTotalPrice());
        orderAuthDto.setUpPrice(orderAuthInfo.getUpPrice());
        orderAuthDto.setOperAccount(orderAuthInfo.getOperAccount());
        orderAuthDto.setStatus(orderAuthInfo.getStatus());
        Park park = (Park)this.parkService.findByParkId(Long.valueOf(orderAuthInfo.getParkId().intValue())).getData();
        if (!Objects.isNull(park)) {
            orderAuthDto.setParkName(park.getParkName());
        }
        if (!Objects.isNull(parkInoutdevice = (ParkInoutdevice)this.parkService.getInoutDeviceById(Long.valueOf(orderAuthInfo.getInandoutId().intValue())).getData())) {
            orderAuthDto.setAisleName(parkInoutdevice.getInandoutName());
        }
        if (!Objects.isNull((byOrderNum = this.orderService.findByOrderNum(orderAuthInfo.getOrderNum())).getData())) {
            orderAuthDto.setPlateNum(((OrderInfo)byOrderNum.getData()).getPlateNum());
            OrderCarInfo carInfo = this.orderCarInfoDao.selectByOrderNum(((OrderInfo)byOrderNum.getData()).getOrderNum());
            if (carInfo != null) {
                String imageUrl = this.ossService.getImageUrl(carInfo.getEnterImage());
                orderAuthDto.setImage(imageUrl);
            }
        }
        orderAuthDto.setAuthStatus(orderAuthInfo.getAuthStatus());
        return ObjectResponse.success((Object)orderAuthDto);
    }

    @DS_SLAVE
    @SentinelResource(value="OrderAuthService.selectOrderByOrderNum", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<OrderAuthDto> selectOrderByOrderNum(String orderNum, Integer status) {
        OrderAuthInfo orderAuthInfo = this.orderAuthDao.selectByOrderNum(orderNum, status);
        if (orderAuthInfo != null) {
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            OrderAuthDto orderAuthDto = new OrderAuthDto();
            orderAuthDto.setId(orderAuthInfo.getId());
            orderAuthDto.setRemark(orderAuthInfo.getRemark());
            orderAuthDto.setAuthNum(orderAuthInfo.getAuthNum());
            if (orderAuthInfo.getCreateTime() != null) {
                orderAuthDto.setApplyTime(sf.format(orderAuthInfo.getCreateTime()));
            }
            if (orderAuthInfo.getUpdateTime() != null) {
                orderAuthDto.setAnswerTime(sf.format(orderAuthInfo.getUpdateTime()));
            }
            orderAuthDto.setTotalPrice(orderAuthInfo.getTotalPrice());
            orderAuthDto.setUpPrice(orderAuthInfo.getUpPrice());
            Park park = (Park)this.parkService.findByParkId(Long.valueOf(orderAuthInfo.getParkId().intValue())).getData();
            orderAuthDto.setParkName(park.getParkName());
            orderAuthDto.setOperAccount(orderAuthInfo.getOperAccount());
            orderAuthDto.setStatus(orderAuthInfo.getStatus());
            ParkInoutdevice parkInoutdevice = (ParkInoutdevice)this.parkService.getInoutDeviceById(Long.valueOf(orderAuthInfo.getInandoutId().intValue())).getData();
            orderAuthDto.setAisleName(parkInoutdevice.getInandoutName());
            ObjectResponse byOrderNum = this.orderService.findByOrderNum(orderAuthInfo.getOrderNum());
            orderAuthDto.setPlateNum(((OrderInfo)byOrderNum.getData()).getPlateNum());
            orderAuthDto.setAuthStatus(orderAuthInfo.getAuthStatus());
            OrderCarInfo carInfo = this.orderCarInfoDao.selectByOrderNum(((OrderInfo)byOrderNum.getData()).getOrderNum());
            if (carInfo != null) {
                String imageUrl = this.ossService.getImageUrl(carInfo.getEnterImage());
                orderAuthDto.setImage(imageUrl);
            }
            return ObjectResponse.success((Object)orderAuthDto);
        }
        return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
    }

    @DS_SLAVE
    @SentinelResource(value="OrderAuthService.getOrderAuthList", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<List<OrderAuthDto>> getOrderAuthList(OrderAuthQueryRequest orderAuthQueryRequest) {
        String parkCodes = orderAuthQueryRequest.getParkCode();
        List status = orderAuthQueryRequest.getStatus();
        Date endTime = orderAuthQueryRequest.getEndTime();
        Date startTime = orderAuthQueryRequest.getStartTime();
        String[] split = parkCodes.split(",");
        String parkids = this.parkDao.selectByCodes(split);
        PageHelper.startPage((int)orderAuthQueryRequest.getPageNo(), (int)orderAuthQueryRequest.getPageSize());
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List<OrderAuthInfo> records = this.orderAuthDao.selectAuthRecords(parkids, Objects.isNull(startTime) ? null : sf.format(startTime), Objects.isNull(endTime) ? null : sf.format(endTime), status);
        ArrayList enterCarDtos = Lists.newArrayList();
        for (OrderAuthInfo orderAuthInfo : records) {
            ObjectResponse byOrderNum;
            OrderAuthDto orderAuthDto = new OrderAuthDto();
            orderAuthDto.setId(orderAuthInfo.getId());
            orderAuthDto.setRemark(orderAuthInfo.getRemark());
            orderAuthDto.setAuthNum(orderAuthInfo.getAuthNum());
            if (orderAuthInfo.getCreateTime() != null) {
                orderAuthDto.setApplyTime(sf.format(orderAuthInfo.getCreateTime()));
            }
            if (orderAuthInfo.getUpdateTime() != null) {
                orderAuthDto.setAnswerTime(sf.format(orderAuthInfo.getUpdateTime()));
            }
            orderAuthDto.setTotalPrice(orderAuthInfo.getTotalPrice());
            orderAuthDto.setUpPrice(orderAuthInfo.getUpPrice());
            Park park = (Park)this.parkService.findByParkId(Long.valueOf(orderAuthInfo.getParkId().intValue())).getData();
            orderAuthDto.setParkName(park.getParkName());
            orderAuthDto.setOperAccount(orderAuthInfo.getOperAccount());
            orderAuthDto.setStatus(orderAuthInfo.getStatus());
            orderAuthDto.setAuthStatus(orderAuthInfo.getAuthStatus());
            if (orderAuthInfo.getInandoutId() != null) {
                ParkInoutdevice parkInoutdevice = (ParkInoutdevice)this.parkService.getInoutDeviceById(Long.valueOf(orderAuthInfo.getInandoutId().intValue())).getData();
                orderAuthDto.setAisleName(parkInoutdevice.getInandoutName());
            }
            if (ObjectResponse.isSuccess((Response)(byOrderNum = this.orderService.findByOrderNum(orderAuthInfo.getOrderNum())))) {
                OrderInfo data = (OrderInfo)byOrderNum.getData();
                orderAuthDto.setPlateNum(data.getPlateNum());
                Long enterTime = data.getEnterTime();
                if (!Objects.isNull(data.getExitTime())) {
                    orderAuthDto.setParkTime(Long.valueOf(data.getExitTime() - enterTime));
                } else {
                    orderAuthDto.setParkTime(Long.valueOf(System.currentTimeMillis() / 1000L - enterTime));
                }
                orderAuthDto.setParkTimeStr(DateTools.secondToSecondsTime((int)orderAuthDto.getParkTime().intValue()));
            }
            enterCarDtos.add(orderAuthDto);
        }
        return ObjectResponse.success((Object)enterCarDtos);
    }

    @DS_SLAVE
    @SentinelResource(value="OrderAuthService.countOrderAuthList", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse countOrderAuthList(OrderAuthQueryRequest orderAuthQueryRequest) {
        String parkCode = orderAuthQueryRequest.getParkCode();
        Date startTime = orderAuthQueryRequest.getStartTime();
        Date endTime = orderAuthQueryRequest.getEndTime();
        List status = orderAuthQueryRequest.getStatus();
        String[] split = parkCode.split(",");
        String parkids = this.parkDao.selectByCodes(split);
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        int count = this.orderAuthDao.countAuthRecords(parkids, Objects.isNull(startTime) ? null : sf.format(startTime), Objects.isNull(endTime) ? null : sf.format(endTime), status);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("count", count);
        return ObjectResponse.success(map);
    }
}

